/*
 * Szkic web_server_multi_page
 * Odpowiada na żądania w adresie URL w celu wyświetlenia wartości cyfrowych i analogowych pinów wyjścia
 * http://IP_ADDRESS/analogowy/   - wyświetla dane analogowych pinów
 * http://IP_ADDRESS/cyfrowy/  - wyświetla dane cyfrowych pinów
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

const int MAX_PAGE_NAME_LEN = 11;  // Maksymalna liczba znaków w nazwie strony
char buffer[MAX_PAGE_NAME_LEN+1];  // Nazwa strony + końcowy null

void setup() {
  Serial.begin(9600);
 
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  server.begin();
}

#define MSG_DELAY 10000
void loop() {
  static unsigned long nextMsgTime = 0;
  if (millis() > nextMsgTime)
  {
    Serial.print("Odwiedź http://");
    Serial.print(getIP()); Serial.println("/analogowy/");
    nextMsgTime = millis() + MSG_DELAY;
  }

  maintain(); // Utrzymanie dzierżawy DHCP, jeśli jest to konieczne

  client = server.available();
  if (client) 
  {
    while (client.connected()) 
    {
      if (client.available()) 
      {
        if( client.find("GET ") ) 
        {
          // Wyszukanie nazwy strony
          memset(buffer,0, sizeof(buffer)); // Wyczyszczenie buforu
          if(client.find( "/"))    
            if(client.readBytesUntil('/', buffer, MAX_PAGE_NAME_LEN ))  
            {  
              if(strcmp(buffer, "analogowy") == 0)
                showAnalog();
              else if(strcmp(buffer, "cyfrowy") == 0)
                showDigital();
              else
                unknownPage(buffer);
            }       
        }
        Serial.println();
        break; // Wyjście z pętli while()
      }
    }
    // Czas dla przeglądarki na odebranie danych
    delay(1);
    client.stop();
  }
}

void showAnalog()
{
  Serial.println("analogowy");
  sendHeader();
  client.println("<h1>Piny analogowe</h1>");
  // Wyświetlenie wartości każdego analogowego pinu wejścia
  for (int i = 0; i < 6; i++) 
  {
    client.print("pin analogowy ");
    client.print(i);
    client.print(" = ");
    client.print(analogRead(i));
    client.println("<br />");
  }
}

void showDigital()
{
  Serial.println("cyfrowy");
  sendHeader();
  client.println("<h1>Piny cyfrowe</h1>");
  // Wyświetlenie wartości każdego cyfrowego pinu wejścia
  for (int i = 2; i < 8; i++) 
  {
    pinMode(i, INPUT_PULLUP);
    client.print("pin cyfrowy ");
    client.print(i);
    client.print(" to ");
    if(digitalRead(i) == LOW)
      client.print("HIGH");
    else
      client.print("LOW");
    client.println("<br />");
  }
  client.println("</body></html>");
}

void unknownPage(char *page)
{
  sendHeader();
  client.println("<h1>Strona nieznana</h1>");
  client.print(page);
  client.println("<br />");
  client.println("Rozpoznane strony to:<br />");
  client.println("/analogowy/<br />");
  client.println("/cyfrowy/<br />");
  client.println("</body></html>");
}

void sendHeader()
{
  // Wysłanie standardowego nagłówka odpowiedzi HTTP
  client.println("HTTP/1.1 200 OK");
  client.println("Typ zawartości: text/html");
  client.println();
  client.println("<html><head><title>Przykład: Serwer z wieloma stronami</title>");
  client.println("<body>");
}
