/*
 * Szkic web_server
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

void setup() {
  Serial.begin(9600);
  
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1) 
    {
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  server.begin();
}

#define MSG_DELAY 10000
void loop() {
  static unsigned long nextMsgTime = 0;
  if (millis() > nextMsgTime)
  {
    Serial.print("Odwiedź http://");
    Serial.println(getIP());
    nextMsgTime = millis() + MSG_DELAY;
  }

  maintain(); // Utrzymanie dzierżawy DHCP, jeśli jest to konieczne

  client = server.available(); // Nasłuchiwanie połączeń
  if (client) {
    Serial.println("Połączenie nowego klienta");
    
    // Żądanie http jest zakończone pustą linijką
    boolean currentLineIsBlank = true;
    while (client.connected()) 
    {
      if (client.available()) 
      {
        char c = client.read();
        Serial.write(c);
        // Jeśli doszedłeś do końca pustej linijki i znalazłeś kolejny znak \n,
        // to znaczy, że dotarłeś do końca nagłówka
        if (c == '\n' && currentLineIsBlank) 
        {
          // Wysłanie standardowego nagłówka odpowiedzi HTTP
          client.println("HTTP/1.1 200 OK");
          client.println("Typ zawartości: text/html");
          client.println("Połączenie: zamknięte"); // Zamknij połączenie po odpowiedzi
          client.println("Odświeżanie: 5");  // Automatycznie odświeżanie co 5 s
          client.println(); // Koniec nagłówków

          client.println("<!DOCTYPE HTML>");
          client.println("<HTML>");
          
          // Wyświetlanie wartości każdego analogowego pinu wejścia
          for (int analogChannel = 0; analogChannel < 6; analogChannel++) 
          {
            int sensorReading = analogRead(analogChannel);
            client.print("A");   client.print(analogChannel);
            client.print(" = "); client.print(sensorReading);
            client.println("<BR />");
          }
          client.println("</HTML>");
          break; // wyjście z pętli loop
        }
        if (c == '\n') 
        {
          // początek nowej linii
          currentLineIsBlank = true;
        } 
        else if (c != '\r') 
        {
          // W bieżącej linijce jest jakiś znak
          currentLineIsBlank = false;
        }
      }
    }
    // Czas dla przeglądarki internetowej na odebranie danych
    delay(100);

    // zamknięcie połączenia
    client.stop();
    Serial.println("Klient rozłączony");
  }
}
