/*
 *  Szkic udp_analog
*/

#include <SPI.h>
#include <Ethernet.h>
#include <EthernetUDP.h>

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; // Adres MAC

unsigned int localPort = 8888;      // Nasłuchiwany port lokalny

char packetBuffer[UDP_TX_PACKET_MAX_SIZE]; // Bufor do zapisywania otrzymanych pakietów
int packetSize; // Zmienna przechowująca rozmiar pakietu

const int analogOutPins[] = { 3, 5, 6, 9 }; // Piny 10 i 11, używane przez nakładkę Ethernet

//  Instancja UDP umożliwiająca wysyłanie i odbieranie wiadomości przez UDP
EthernetUDP Udp;

void setup() 
{
  Ethernet.begin(mac);
  Udp.begin(localPort);

  Serial.begin(9600);
  Serial.println("Gotowy");
}

void loop() 
{
  // Gdy są dostępne dane, odczytaj pakiet
  packetSize = Udp.parsePacket();
  if (packetSize > 0)
  {
    Serial.print("Otrzymano pakiet o rozmiarze: ");
    Serial.print(packetSize);
    Serial.println(" z zawartością:");
    // Odczytanie pakietu do packetBuffer oraz uzyskanie adresu IP nadawcy i numeru portu
    packetSize = min(packetSize, UDP_TX_PACKET_MAX_SIZE);
    Udp.read(packetBuffer, UDP_TX_PACKET_MAX_SIZE);

    for ( int i = 0; i < packetSize; i++)
    {
      byte value = packetBuffer[i];
      if (i < 4)
      {
        // Zapis tylko do czterech pierwszych analogowych pinów wyjścia
        analogWrite(analogOutPins[i], value);
      }
      Serial.println(value, DEC);
    }
    Serial.println();
    // Wysłanie nadawcy wartości portów analogowych
    sendAnalogValues(Udp.remoteIP(), Udp.remotePort());
  }
  maintainLease();
  // Krótka przerwa
  delay(10);
}

void sendAnalogValues( IPAddress targetIp, unsigned int targetPort )
{
  Serial.println("Przygotowywanie pakietu");
  int index = 0;
  for (int i = 0; i < 6; i++)
  {
    int value = analogRead(i);

    packetBuffer[index++] = lowByte(value);  // Dolny bajt
    packetBuffer[index++] = highByte(value); // Górny bajt
  }

  Serial.println(packetBuffer);
  // Odesłanie pakietu do nadawcy
  Udp.beginPacket(targetIp, targetPort);
  Udp.write(packetBuffer);
  Udp.endPacket();
  Serial.println("Pakiet wysłany");
}

#define MAINTAIN_DELAY 750 // Utrzymanie dzierżawy DHCP co 0,75 s
void maintainLease()
{
  static unsigned long nextMaintain = millis() + MAINTAIN_DELAY;
  if (millis() > nextMaintain)
  {
      Serial.print("Utrzymanie ");
    nextMaintain = millis() + MAINTAIN_DELAY;
    int ret = Ethernet.maintain();
    if (ret == 1 || ret == 3)
    {
      Serial.print("Nie udało się utrzymać dzierżawy DHCP. Błąd: ");
      Serial.println(ret);
    }
    Serial.print("Obecny adres IP: ");
    IPAddress myIPAddress = Ethernet.localIP();
    Serial.println(myIPAddress);
  }
}
