/*
 * Szkic ntp
 * Pobiera godzinę z serwera czasu NTP
 * Pokazuje zastosowanie funkcji UDP: sendPacket oraz ReceivePacket
 */

#include <SPI.h>   
#include <Ethernet.h>

#include <EthernetUDP.h>

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };  // adres MAC

unsigned int localPort = 8888;      // Nasłuchiwany port lokalny

IPAddress timeServer(129, 6, 15, 28); // Serwer NTP time.nist.gov

//IPAddress timeServer(132, 163, 96, 5); // Serwer NTP ntp-b.nist.gov
const int NTP_PACKET_SIZE= 48; // Znacznik czasu NTP znajduje się w pierwszych 48 bajtach wiadomości

byte packetBuffer[ NTP_PACKET_SIZE]; // Bufor do przechowywania wychodzących i przychodzących pakietów

// Instancja UDP umożliwiająca wysyłanie i odbieranie wiadomości przez UDP
EthernetUDP Udp;

void setup()
{
  Serial.begin(9600);
  // Uruchomienie Ethernetu i UDP
  if (Ethernet.begin(mac) == 0) {
    Serial.println("Nie udało się skonfigurować Ethernetu za pomocą DHCP");
    while(1); // Zatrzymanie programu
  }
  Udp.begin(localPort);
}

void loop()
{
  sendNTPpacket(timeServer); // Wysyłanie pakietu NTP do serwera czasu
  // Czekanie na odpowiedź
  delay(1000);
  if ( Udp.parsePacket() ) 
  { 
    Serial.println("przeanalizowano");
    Udp.read(packetBuffer,NTP_PACKET_SIZE);  // Wczytanie pakietu do bufora

    //Znacznik czasu zaczyna się od 40 bajta, konwersja 4 bajtów na liczbę całkowitą typu long
    unsigned long hi = word(packetBuffer[40], packetBuffer[41]);
    unsigned long low = word(packetBuffer[42], packetBuffer[43]);
    unsigned long secsSince1900 = hi << 16 | low;  // Czas NTP 
                                                    // (sekundy od 1 stycznia 1900)

    Serial.print("Sekundy od 1 stycznia 1900 = " );
    Serial.println(secsSince1900);

    Serial.print("Czas uniksowy = ");
    // Czas uniksowy zaczyna się od 1 stycznia 1970.
    const unsigned long seventyYears = 2208988800UL;     
    unsigned long epoch = secsSince1900 - seventyYears;  // Odjęcie 70 lat
    Serial.println(epoch);                               // Wyświetlenie czasu uniksowego

    // Wyświetlenie godziny, minut i sekund:
    // UTC to czas słoneczny średni na południku zerowym (GMT)
    Serial.print("Czas UTC to ");       
    // Wyświetlenie godziny (doba ma 86400 s)
    Serial.print((epoch  % 86400L) / 3600); 
    Serial.print(':');
    if ( ((epoch % 3600) / 60) < 10 ) 
    {
      // Dodanie początkowego zera dla pierwszych 10 minut każdej godziny
      Serial.print('0');
    }
    // Wyświetlenie minut (minuta ma 3600 s)
    Serial.print((epoch  % 3600) / 60);
    Serial.print(':');
    if ( (epoch % 60) < 10 ) 
    {
      // Dodanie początkowego zera dla pierwszych 10 s każdej minuty
      Serial.print('0');
    }
    Serial.println(epoch %60); // Wyświetlenie sekund
  }
  // Poczekaj 10 s przed ponownym sprawdzeniem godziny
  delay(10000);
}

// Wysłanie żądania NTPna serwer czasu o podanym adresie
unsigned long sendNTPpacket(IPAddress& address)
{
  memset(packetBuffer, 0, NTP_PACKET_SIZE);  // Ustawienie wszystkich bajtów w buforze na 0

  // Inicjalizacja wartości potrzebnych do utworzenia żądania NTP
  packetBuffer[0] = B11100011;   // Wskaźnik sekund przestępnych, wersja, tryb
  packetBuffer[1] = 0;     // Warstwa
  packetBuffer[2] = 6;     // Maksymalna przerwa między wiadomościami (w sekundach)
  packetBuffer[3] = 0xEC;  // Dokładność zegara
  // Bajty 4 - 11 to opóźnienie pomiędzy nadawcą a serwerem warstwy 1
  // oraz maksymalny błąd pomiędzy zegarem lokalnym a serwera warstwy 1,
  // są ustawione na 0 przez memset
  packetBuffer[12]  = 49;  // 4 bajty identyfikatora źródła czasu
  packetBuffer[13]  = 0x4E;
  packetBuffer[14]  = 49;
  packetBuffer[15]  = 52;

  // Gdy wszystkie pola NTP mają już nadane wartości,
  // możesz wysłać żądanie o znacznik czasu:        
  Udp.beginPacket(address, 123); //Żądania NTP są wysyłane portem 123
  Udp.write(packetBuffer,NTP_PACKET_SIZE);
  Udp.endPacket();
}
