/*
  Szkic xbee_actuator_series2_series3
  Wysyła polecenie typu Remote AT w celu aktywowania cyfrowego pinu innego XBee
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
//#define MYSERIAL Serial // Uno, Nano i inne płytki AVR
#define MYSERIAL Serial1 // Nano Every, Uno WiFi R2, Leonardo oraz płytki ARM

const byte frameStartByte = 0x7E;
const byte frameTypeRemoteAT  = 0x17;
const byte remoteATOptionApplyChanges = 0x02;

void setup() 
{
  MYSERIAL.begin(9600);
}

void loop()
{
  toggleRemotePin(1);
  delay(2000);
  toggleRemotePin(0);
  delay(2000);
}

byte sendByte(byte value) 
{
  MYSERIAL.write(value);
  return value;
}

void toggleRemotePin(int value) // 0 = wyłączone, różne od zera = włączone
{  
  byte pin_state;
  if (value) 
  {
    pin_state = 0x5;
  } 
  else 
  {
    pin_state = 0x4;
  }

  sendByte(frameStartByte); // Inicjalizacja API

  // Górne i dolne części długości ramy API (z pominięciem sum kontrolnych)
  sendByte(0x0);
  sendByte(0x10);

  long sum = 0; // Zmienna przechowująca dodane kolejne sumy kontrolne

  sum += sendByte(frameTypeRemoteAT); // Ta rama zawiera polecenie typu Remote AT

  sum += sendByte(0x0);  // Ustawienie ID ramy na zero w przypadku braku odpowiedzi

  // Poniższe 8 bajtów wskazują ID odbiorcy
  // Użyj 0xFFFF, aby nadawać do wszystkich węzłów
  sum += sendByte(0x0);
  sum += sendByte(0x0);
  sum += sendByte(0x0);
  sum += sendByte(0x0);
  sum += sendByte(0x0);
  sum += sendByte(0x0);
  sum += sendByte(0xFF);
  sum += sendByte(0xFF);

  // Poniższe 2 bajty wskazują 16-bitowy adres odbiorcy
  // Użyj 0xFFFF, aby nadawać do wszystkich węzłów
  sum += sendByte(0xFF);
  sum += sendByte(0xFF);

  sum += sendByte(remoteATOptionApplyChanges); // Wysłanie opcji polecenia Remote AT

  // Tekst polecenia AT
  sum += sendByte('D');
  sum += sendByte('1');

  // 0x4, aby wyłączyć, 0x5, aby wyłączyć
  sum += sendByte(pin_state);

  // Wysłanie sumy kontrolnej
  sendByte( 0xFF - ( sum & 0xFF));

  delay(10); // Przerwa na ustabilizowanie się mikrokontrolera
}
