/*
 * Szkic i2c_multiple_secondary
 * Monitoruje żądania I2C i przesyła je dalej do portu szeregowego
 */

#include <Wire.h>

const int address = 4;  //Adres używany przez komunikujące się ze sobą urządzenia

void setup()
{
  Serial.begin(9600);
  Wire.begin(address); // Połączenie magistrali I2C za pomocą tego adresu
  Wire.onReceive(receiveEvent); // Zarejestrowanie wydarzenia obsługującego żądania
}

void loop()
{
  // Nie jest wymagany żaden kod, gdyż wszystko jest wykonywane przez funkcję receiveEvent
}

void receiveEvent(int howMany)
{
  while(Wire.available() > 0)
  {
    char c = Wire.read(); // Odczytanie bajta jako znaku
    if( c == 'H') {
       // Początek wiadomości
       int nbrSensors = Wire.parseInt();
       if(nbrSensors > 0) {
          for(int i=0; i < nbrSensors; i++ ) {
            int val = Wire.parseInt();
            Serial.print(val); Serial.print(" ");
          }
          Serial.println();
       }       
    }
  }
}
