/*
 * Szkic timertc
 * Przykładowy kod pokazujący zastosowanie biblioteki Time z zegarem czasu rzeczywistego
 *
 */

#include <TimeLib.h>
#include <Wire.h>
#include <DS1307RTC.h>  // Podstawowa biblioteka DS1307 zwracająca czas jako time_t

void setup()  {
  Serial.begin(9600);
  while(!Serial); // Dla Leonardo i 32-bitowych płytek
  
  setSyncProvider(RTC.get);   // Funkcja pobierająca czas z zegara RTC
  if(timeStatus()!= timeSet)
     Serial.println("Nie można zsynchronizować z RTC");
  else
     Serial.println("RTC ma czas systemowy");
}

void loop()
{
   digitalClockDisplay();
   delay(1000);
}

// Dodanie początkowych zer do cyfr
String padDigits(int digit)
{
  String str = String("0") + digit; // Dodanie zera przez cyfrą
  return str.substring(str.length() - 2); // Usunięcie wszystkich znaków, oprócz dwóch ostatnich
}

void digitalClockDisplay(){
  String timestr = String(hour()) + ":" + padDigits(minute()) +
                   ":" + padDigits(second());
  Serial.println(timestr);
  
  String datestr = String(year()) + "-" + padDigits(month()) + 
                   "-" + padDigits(day()); 
  Serial.println(datestr);
}
