/*
 * Szkic settimeserialtime
 * Ustawienie czasu z portu szeregowego; uproszczona wersja przykładowego szkicu TimeSerial z biblioteki Time
 *
 * Ustaw czas przez wysłanie litery T i cyfr oznaczających liczbę sekund, które upłynęły do 1 stycznia 1970 roku,
 * na przykład T1569888000 to 12:00, 1 października 2019
 */


#include <TimeLib.h>

#define TIME_HEADER  'T'   // Nagłówek wiadomości synchronizacji czasu

void setup()  {
  Serial.begin(9600);
  Serial.println("Czekanie na wiadomość synchronizacji czasu");
}

void loop(){
  if(Serial.available())
  {
    processSyncMessage();
  }
  if(timeStatus() != timeNotSet)
  {
    // Wyświetlenie cxasu i godziny
    digitalClockDisplay();
  }
  delay(1000);
}

// Dodanie początkowych zer do cyfr
String padDigits(int digit)
{
  String str = String("0") + digit; // Dodanie zera przez cyfrą
  return str.substring(str.length() - 2); // Usunięcie wszystkich znaków, oprócz dwóch ostatnich
}

void digitalClockDisplay(){
  String timestr = String(hour()) + ":" + padDigits(minute()) +
                   ":" + padDigits(second());
  Serial.println(timestr);
  
  String datestr = String(year()) + "-" + padDigits(month()) + 
                   "-" + padDigits(day()); 
  Serial.println(datestr);
}

// Analiza wiadomości z czasem
void processSyncMessage() {

  time_t pctime = 0;

  if(Serial.find(TIME_HEADER)) {
     pctime = Serial.parseInt();
     setTime(pctime); // Ustawienie zegara na czas otrzymany z portu szeregowego
  }

}
