/*
 * szkic melody_beats
 * Szkic grający melodię "Twinkle, Twinkle Little Star"
 * Głośnik jest podłączony do pinu 9.
 */

const int speakerPin = 9; // pin głośnika

char noteNames[] = {'C','D','E','F','G','a','b'};
unsigned int frequencies[] = {262,294,330,349,392,440,494};
const byte noteCount = sizeof(noteNames); // liczba nut (7)

//notes, a space represents a rest
char score[] = "CCGGaaGFFEEDDC GGFFEEDGGFFEED CCGGaaGFFEEDDC ";  
const byte scoreLen = sizeof(score); // liczba nut w partyturze

byte beats[scoreLen] = {1,1,1,1,1,1,2,  1,1,1,1,1,1,2,1,
                        1,1,1,1,1,1,2,  1,1,1,1,1,1,2,1,
                        1,1,1,1,1,1,2,  1,1,1,1,1,1,2};
byte beat = 180; // liczba taktów na minutę dla ośmiu nut
unsigned int speed = 60000 / beat; // długość w milisekundach jednego taktu

void setup()
{
}

void loop()
{
  for (int i = 0; i < scoreLen; i++)
  {
    int duration = beats[i] * speed; // wykorzystanie tablicy beats do określenia długości nuty
    playNote(score[i], duration); // odtworzenie dźwięku
    delay(duration/10); // krótka pauza między nutami
  }

  delay(4000); // Czekaj 4 sekundy przed powtórzeniem piosenki.
}

void playNote(char note, int duration)
{
  // Odtwórz dźwięk o częstotliwości odpowiadającej nazwie nuty.
  for (int i = 0; i < noteCount; i++)
  {
    // Spróbuj znaleźć w tablicy noteNames odpowiednią nutę i uzyskać jej indeks.
    if (noteNames[i] == note) // szukanie pasującej nuty w tablicy
      tone(speakerPin, frequencies[i], duration); //  odtworzenie dźwięku
  }
  // Jeśli nie odnaleziono nuty, oznacza to pauzę, więc wywołaj funkcję delay.
  delay(duration);
}
