/*
 * Szkic vibrate_photocell
 * Silnik wibruje, gdy fotokomórka wykryje światło jaśniejsze niż oświetlenie otoczenia 
 */

const int motorPin  = 3;  // Tranzystor silniczka wibracyjnego podłączony do pinu 3
const int sensorPin = A0; // Fotokomórka podłączona do analogowego pinu 0
int sensorAmbient = 0;             // Poziom światła otoczenia (kalibracja w funkcji setup)
const int thresholdMargin = 100;   // Wartość progowa, po której przekroczeniu silnik powinien wibrować

void setup()
{
  pinMode(motorPin, OUTPUT);
  sensorAmbient = analogRead(sensorPin); // Ustawienie początkowego poziomu jasności
}

void loop()
{
  int sensorValue = analogRead(sensorPin);
  if( sensorValue > sensorAmbient + thresholdMargin)
  {
    digitalWrite(motorPin,  HIGH); // Wibracja
  }
  else
  {
    digitalWrite(motorPin,  LOW);   // Koniec wibracji
  }
}
