/*
 * Szkic hbridge_direction
 * Sterowanie kierunkiem obrotu silnika za pomocą czujników światła
 * Robot porusza się w kierunku światła
 */

int leftPins[]  = {5,7,4};  // Dwa piny dla kierunku silnika (PWM)
int rightPins[] = {6,3,2};

const int MIN_PWM        = 64;  // Zakres od 0 do MAX_PWM
const int MAX_PWM        = 128; // Zakres od około 50 do 255
const int leftSensorPin  = A0;  // Piny analogowe czujników
const int rightSensorPin = A1;

int sensorThreshold = 0; // Wartość progowa poziomu światła, po której osiągnięciu  silnik się porusza

void setup()
{
  for(int i=1; i < 3; i++)
  {
    pinMode(leftPins[i], OUTPUT);
    pinMode(rightPins[i], OUTPUT);
  }
}

void loop()
{
  int leftVal = analogRead(leftSensorPin);
  int rightVal = analogRead(rightSensorPin);
  
  if(sensorThreshold == 0) // Czy czujnki zostały skalibrowane?
  {  
    // Jeśli nie, skalibruj czujniki do wartości zbliżonej do średniej jasności otoczenia 
    sensorThreshold = ((leftVal + rightVal) / 2) + 100 ;  
  }  

  if( leftVal > sensorThreshold || rightVal > sensorThreshold)
  {
    // Jeśli jest odpowiednio dużo światła, robot jedzie
    setSpeed(rightPins, map(rightVal,0,1023, MIN_PWM, MAX_PWM));
    setSpeed(leftPins,  map(leftVal ,0,1023, MIN_PWM, MAX_PWM));
  }
}

void setSpeed(int pins[], int speed )
{
  if(speed < 0)
  {
    digitalWrite(pins[1],HIGH);
    digitalWrite(pins[2],LOW);
    speed = -speed;
  }
  else
  {
    digitalWrite(pins[1],LOW);
    digitalWrite(pins[2],HIGH);
  }
  analogWrite(pins[0], speed);
}
