/*
 * Szkic brushed_hbridge_with_speed
 * Sterowanie kierunkiem obrotu silników i prędkością za pomocą poleceń odbieranych z portu szeregowego
 * przyjmowane są cyfry od '0' do '9', gdzie '0' to zatrzymanie silnika, '9' to maksymalna prędkość 
 * + lub to ustawienie kierunku
 */

const int enPin  = 5;  // Pin aktywujący mostku H
const int in1Pin = 7;  // Piny wejścia mostku H
const int in2Pin = 4;

void setup()
{
  Serial.begin(9600);
  pinMode(in1Pin, OUTPUT);
  pinMode(in2Pin, OUTPUT);
  Serial.println("Prędkość (0-9) lub + - w celu ustawienia kierunku");
}

void loop()
{
  if ( Serial.available()) 
  {
    char ch = Serial.read();

    if(isDigit(ch)) // Czy zmienna ch to liczba?
    {
      int speed = map(ch, '0', '9', 0, 255);
      analogWrite(enPin, speed);
      Serial.println(speed);
    }
    else if (ch == '+')
    {
      Serial.println("zgodnie z kierunkiem wskazówek zegara");
      digitalWrite(in1Pin,LOW);
      digitalWrite(in2Pin,HIGH);
    }
    else if (ch == '-')
    {
      Serial.println("przeciwnie do kierunku wskazówek zegara");
      digitalWrite(in1Pin,HIGH);
      digitalWrite(in2Pin,LOW);
    }
    else if (ch != '\n' && ch != '\r') // Pominięcie znaku nowej linii lub powrotu karetki
    {
      Serial.print("Błędny znak ");
      Serial.println(ch);
    }
  }
}
