/*
 * szkic matrix _mpx_pot
 *
 * Sekwencja zapalająca po kolei wszystkie  diody LED, zaczynając od pierwszej kolumny i wiersza, aż do ostatniego.
 * Dzięki multipleksowaniu 64 diody LED są sterowane za pomocą 16 pinów.
 */

const int columnPins[] = {2, 3, 4, 5, 6, 7, 8, 9};
const int rowPins[]    = {10,11,12,A1,A2,A3,A4,A5};

int pixel       = 0; // 0 do 63 diod LED w tavlicy
int columnLevel = 0; // wartość piksela zamieniona na kolumnę LED
int rowLevel    = 0; // wartość piksela zamieniona na wiersz LED

void setup() 
{
  for (int i = 0; i < 8; i++)
  {
    pinMode(columnPins[i], OUTPUT);  // ustawienie wszystkich pinów diod LED jako wyjście
    pinMode(rowPins[i], OUTPUT);
  }
}

void loop() 
{
  int sensorValue = analogRead(0);             // odczyt wartości analogowej
  pixel = map(sensorValue, 0, 1023, 0, 63);    // przeskalowanie wartość czujnika do liczby pikseli (diod)


  columnLevel = pixel / 8;  // przeskalowanie do liczby kolumn
  rowLevel = pixel % 8;     // obliczenie część ułamkową

  for (int column = 0; column < 8; column++)
  {
    digitalWrite(columnPins[column], LOW);     // podłączenie kolumny do masy
    for(int row = 0; row < 8; row++)
    {
      if (columnLevel > column)
      {
        digitalWrite(rowPins[row], HIGH);  // podłączenie wszystkich diod LED w wierszu do napięcia
      }
      else if (columnLevel == column && rowLevel >= row)
      {
          digitalWrite(rowPins[row], HIGH);
      }
      else
      {
        digitalWrite(columnPins[column], LOW); // wyłączenie wszystkich diod LED w wierszu
      }
      delayMicroseconds(300);    // Funkcja delay określa ramy czasowe (20 ms) dla 64 diod LED.
      digitalWrite(rowPins[row], LOW);  // wyłączenie diody LED
    }

    // odłączenie kolumny od masy
    digitalWrite(columnPins[column], HIGH);   
  }
}
