/*
 * Szkic matrix_mpx_only_one
 *
 * Sekwencja zapalająca pojedynczo wszystkie diody LED, od pierwszej kolumny i pierwszego wiersza do ostatnich
 * Dzięki multipleksowaniu 64 diody LED są sterowane za pomocą 16 pinów
 */

const int columnPins[] = {2, 3, 4, 5, 6, 7, 8, 9};
const int rowPins[]    = {10,11,12,A1,A2,A3,A4,A5};

int pixel       = 0; // 0 do 63 diod LED w tablicy

void setup() 
{
  for (int i = 0; i < 8; i++)
  {
    pinMode(columnPins[i], OUTPUT);  // Ustawienie wszystkich pinów diod LED jako wyjścia
    pinMode(rowPins[i], OUTPUT);
    digitalWrite(columnPins[i], HIGH);   
  }
}

void loop() 
{
  pixel = pixel + 1;
  if(pixel > 63)
     pixel = 0;

  int column = pixel / 8;  // Skalowanie do liczby kolumn
  int row = pixel % 8;     // Oblicz wartość ułamkową

  digitalWrite(columnPins[column], LOW);  // Podłączenie kolumny do masy
  digitalWrite(rowPins[row], HIGH);       // Ustawienie stanu wysokiego dla wiersza 
  
  delay(125);  // krótka pauza

  digitalWrite(rowPins[row], LOW);        // Ustawienie stanu niskiego dla wiersza 
  digitalWrite(columnPins[column], HIGH); // Odłączenie kolumny od masy
 
}
