/*
 * Szkic led_brightness
 * Steruje jasnością diod LED podłączonych do analogowych portów wyjścia
 */

const int firstLed   = 3; // Pin dla każdej diody LED
const int secondLed  = 5;
const int thirdLed   = 6;

int brightness = 0;
int increment  = 1;

void setup()
{
  // Piny sterowane przez analogWrite nie muszą być zadeklarowane jako wyjścia
}

void loop()
{
  if(brightness > 255)
  {
    increment = -1; // Po osiągnięciu 255, zacznij odliczać w dół
  }
  else if(brightness < 1)
  {
    increment =  1; // Po osiągnięciu 0, zacznij odliczać w górę
  }
  brightness = brightness + increment; // Inkrementacja (lub dekrementacja)

  // Zapisanie wartości jasności na pinie diody LED
  analogWrite(firstLed, brightness);
  analogWrite(secondLed, brightness);
  analogWrite(thirdLed, brightness );

  delay(10); // 10 ms na każdą zmianę kroku oznacza 2,55 s na rozjaśnienie lub wygaszenie
}
