/*
 * Szkic charlieplex
 * Zapalenie po kolei sześciu diod LED, podłączonych do pinów 2, 3 i 4
 */

int pins[] = {2,3,4};  // Piny, do których podłączone są diody LED

// Następne dwie linie obliczają liczbę pinów i diod LED na podstawie powyższych tablic
const int NUMBER_OF_PINS = sizeof(pins)/ sizeof(pins[0]);
const int NUMBER_OF_LEDS = NUMBER_OF_PINS * (NUMBER_OF_PINS-1);

byte pairs[NUMBER_OF_LEDS/2][2] = { {2,1}, {1,0}, {2,0} }; // Mapowanie pinów do diod LED

void setup()
{
   // Żadne ustawienia nie są wymagane
}

void loop(){
    for(int i=0; i < NUMBER_OF_LEDS; i++)
    {
       lightLed(i);  // Zapalanie po kolei wszystkich diod LED
       delay(1000);
    }
}

// Funkcja zapalająca podaną diodę LED, pierwsza ma numer 0
void lightLed(int led)
{
  // Poniższe cztery linijki zamieniają numer diody LED na numer pinu
  int indexA = pairs[led/2][0];
  int indexB = pairs[led/2][1];
  int pinA = pins[indexA];
  int pinB = pins[indexB];

  // Wyłączenie wszystkich pinów niepodłączonych do podanej diody LED
  for(int i=0; i < NUMBER_OF_PINS; i++)
  {
    if(pins[i] != pinA && pins[i] != pinB)
    {  // Jeśli ten pin nie jest żadnym z naszych pinów,
        pinMode(pins[i], INPUT);   // ustaw tryb na wejście,
        digitalWrite(pins[i],LOW); // upewnij się, że rezystory podciągające są wyłączone
    }
  }
  // Teraz włącz piny dla podanej diody LED
  pinMode(pinA, OUTPUT);
  pinMode(pinB, OUTPUT);
  if( led % 2 == 0)
  {
     digitalWrite(pinA,LOW);
     digitalWrite(pinB,HIGH);
  }
  else
  {
     digitalWrite(pinB,LOW);
     digitalWrite(pinA,HIGH);
  }
}
