/* Szkic mic
 * Płytka mikrofonu elektretowego firmy SparkFun została podłączona do analogowego pinu 0
 */

const int micPin = A0;            // Mikrofon podłączony do pinu 0
const int ledPin = LED_BUILTIN;   // Kod będzie powodował miganie wbudowanej diody LED
const int middleValue = 512;      // Środek zakresu wartości analogowych
const int numberOfSamples = 128;  // Liczba wykonywanych każdorazowo odczytów

int sample;                       // Wartość odczytana z mikrofonu
long signal;                      // Odczyt po usunięciu napięcia niezrównoważenia
long newReading;                  // Średnia odczytów w danym obiegu pętli

long runningAverage = 0;          // Średnia ruchoma obliczonych wartości
const int averagedOver = 16;      // Jak bardzo nowe wartości wpływają na średnią ruchomą
                                  // Większa wartość oznacza mniejszy wpływ

const int threshold = 400;        // Po przekroczeniu tej wartości dioda LED zostaje zapalona

void setup() 
{
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600);
}

void loop() 
{
  long sumOfSquares = 0;
  for (int i=0; i<numberOfSamples; i++) { // Wykonaj wiele odczytów i wyciągnij z nich średnią
    sample = analogRead(micPin);          // Wykonanie pojedynczego odczytu
    signal = (sample - middleValue);      // Obliczenie offsetu ze środkowej wartości
    signal *= signal;                     // Podniesienie do kwadratu w celu uzyskania wartości dodatnich
    sumOfSquares += signal;               // Dodanie do sumy
  }

  newReading = sumOfSquares/numberOfSamples;

  // Obliczenie średniej ruchomej
  runningAverage=(((averagedOver-1)*runningAverage)+newReading)/averagedOver;

  Serial.print("nowa:"); Serial.print(newReading);
  Serial.print(",");
  Serial.print("ruchoma:"); Serial.println(runningAverage);

  if (runningAverage>threshold){         // Czy średnia jest wyższa od wartości progowej?
    digitalWrite(ledPin, HIGH);          // Jeśli tak, włącz diodę LED, 
  }else{
    digitalWrite(ledPin, LOW);           // jeśli nie, zgaś diodę LED
  }

}
