/* Szkic PN532_Serial
 * Czytnik NFC - połączenie szeregowe
 * Odczytuje etykietę NFC i wyświetla jej unikalny numer identyfikacyjny
 */
 
#include <NfcAdapter.h>
#include <PN532/PN532/PN532.h>
#include <PN532/PN532_HSU/PN532_HSU.h>

PN532_HSU pn532hsu(Serial1);
NfcAdapter nfc(pn532hsu);

void setup() 
{
  Serial.begin(9600);
  nfc.begin(); // Inicjalizacja czytnika NFC
}

void loop() 
{
  Serial.println("Oczekiwanie na zbliżenie etykiety do czytnika");
  if (nfc.tagPresent()) // Jeśli czytnik widzi naklejkę NFC,
  {
    NfcTag tag = nfc.read(); // odcztuje ją
    Serial.println(tag.getUidString()); // i wyświetla jej ID.
  }
  delay(500);
}
