/*
 Szkic SwitchTimeMultiple
 Wyświetla jak długo więcej niż jeden przycisk był wciśnięty
 */

const int switchAPin = 2;  // Pin dla przycisku A
const int switchBPin = 3;  // Pin dla przycisku B

void setup()
{
  pinMode(switchAPin, INPUT_PULLUP);
  pinMode(switchBPin, INPUT_PULLUP);
  Serial.begin(9600);
}

void loop()
{
  unsigned long timeA;
  unsigned long timeB;

  timeA = switchATime();
  timeB = switchBTime();

  if (timeA > 0 || timeB > 0)
  {
    Serial.print("czas przycisku A=");
    Serial.print(timeA);

    Serial.print(", czas przycisku B=");
    Serial.println(timeB);
  }
}

unsigned long switchTime(int pin, bool &state, unsigned long  &startTime)
{
  if(digitalRead(pin) != state) // Czy przycisk zmienił stan?
  {
    state = ! state;       // Tak, zmień stan na przeciwny
    startTime = millis();  // Zmienna przechowująca upływający  czas
  }
  if(state == LOW)
  {
    return millis() - startTime;   // Zwrócenie czasu wciskania przycisku w milisekundach
  }
  else
  {
    return 0; // Zwróć 0, jeśli przycisk nie jest wciśnięty (HIGH)
  }
}

long switchATime()
{
  // Poniższe zmienne są statyczne - w Omówieniu znajdziesz wyjaśnienie
  // Czas piewrszego wykrycia zmiany stanu przycisku
  static unsigned long startTime = 0;   
  static bool state;  // Aktualny stan przycisku
  return switchTime(switchAPin, state, startTime);
}

long switchBTime()
{
  // Poniższe zmienne są statyczne - w Omówieniu znajdziesz wyjaśnienie
  // Czas piewrszego wykrycia zmiany stanu przycisku
  static unsigned long startTime = 0;   
  static bool state;  // Aktualny stan przycisku
  return switchTime(switchBPin, state, startTime);
}
