/*
 * Szkic ArduinoPi
 * Pi steruje pinami Arduino za pomocą wiadomości szeregowych.
 * format to: Pn=state 
 * gdzie 'P' jest znakiem nagłówka, n to numer pinu, stan równy jest 0 lub 1
 * na przykład: P13=1  włącza pin 13
 */

// Zamień Serial na Serial1 w przypadku płytek z dodatkowym sprzętowym portem szeregowym.
#define mySerial Serial

void setup()
{
  mySerial.begin(9600); // Inicjalizacja portu, wysyłającego i odbierającego z prędkością 9600
}

void loop()
{
  if (mySerial.available()) // Sprawdź czy dostępny jest przynajmniej jeden znak.
  {
    char ch = mySerial.read();
    int pin = -1;
    if( ch == 'P') // Czy jest to początek wiadomości sterującej pinem?
    {
      pin = mySerial.parseInt();   // Weź numer pinu
    }
    else if (ch == 'B') // Wiadomość usatwiająca stan LED_BUILTIN
    {
      pin = LED_BUILTIN;
    }
    
    if( pin > 1) { // 0 i 1 są zazwyczaj pinami szeregowymi.
      int state = mySerial.parseInt(); // 0 - wyłączone, 1 - włączone
      pinMode(pin, OUTPUT);
      digitalWrite(pin, state);
    }

  }
}
