/*
 * Szkic esp01
 * Sterowanie diodą LED za pomocą strony internetowej
 */

#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

const char* ssid = "TWÓJ";
const char* password = "TWOJE_HASŁO";

ESP8266WebServer server(80);

const int led = LED_BUILTIN;
int ledState = LOW;

// Formularz HTML z przyciskiem
static const char formText[] PROGMEM =
  "<form action=\"/\">\n"
  "<input type=\"hidden\" name=\"toggle\"/>\n"
  "<button type=\"submit\">Toggle LED</button>\n"
  "</form>\n";

// Obsługa żądania z dokumentu głównego  (/)
void handleRoot() 
{
  // Jeśli serwer ma argument "toggle", zmień stan diody LED
  if (server.hasArg("toggle"))
  {
    ledState = !ledState;
    digitalWrite(led, !ledState);
  }

  // Wyświetl formularz
  server.send(200, "text/html", FPSTR(formText));
}

// Informacja o błędzie związanym z nierozpoznanym żądaniem
void handleNotFound() {
  server.send(404, "text/plain", "Nie udało się odnaleźć pliku\n\n");
}

void setup() 
{
  Serial.begin(9600);

  pinMode(led, OUTPUT);
  digitalWrite(led, !ledState);

  // Inicjalizacja Wi-Fi
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);

  // Poczekaj na połączenie
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println();

  // Obsługa strony głównej (/) i wszystkiego innego
  server.on("/", handleRoot);
  server.onNotFound(handleNotFound);

  server.begin(); // Uruchom serwer
}

#define MSG_DELAY 10000
void loop() 
{
  static unsigned long nextMsgTime = 0;
  
  server.handleClient(); // Przetwarzanie żądania od klientów HTTP

  if (millis() > nextMsgTime)
  {
    // Pokaż URL w terminalu portu szeregowego
    Serial.print("Odwiedź mnie na http://");
    Serial.println(WiFi.localIP());
    nextMsgTime = millis() + MSG_DELAY;
  }
}
