/*
 * Szkic wireless_receive
 * Odbiera wiadomość od innego modułu i wysyła odpowiedź
 */
#include <SPI.h>
#include <RH_RF69.h>
#include <RHReliableDatagram.h>

#define MY_ADDR 1 // Adres tego węzła

#define RF69_FREQ 915.0 // Ustawienie obsługiwanej częstotliwości

// defnicja sterownika radia
#define RFM69_INT  3 
#define RFM69_CS   4
#define RFM69_RST  2
RH_RF69 rf69(RFM69_CS, RFM69_INT);

// Obiekt zarządzający dostarczaniem wiadomości
RHReliableDatagram rf69_manager(rf69, MY_ADDR);

void setup() 
{
  Serial.begin(9600);

  pinMode(LED_BUILTIN, OUTPUT);    
  pinMode(RFM69_RST, OUTPUT);
  digitalWrite(RFM69_RST, LOW);

  Serial.println("Ponowne uruchamianie radia");
  digitalWrite(RFM69_RST, HIGH); delay(10);
  digitalWrite(RFM69_RST, LOW); delay(10);
  
  if (!rf69_manager.init()) 
  {
    Serial.println("Nie można uruchomić radia");
    while (1); // Zatrzymanie programu
  }

  if (!rf69.setFrequency(RF69_FREQ)) {
    Serial.println("Nie można ustawić częstotliwości");
    while (1); // Zatrzymanie programu
  }

  // Jeśli używasz wersji  modułu RF69 (RFM69HW/HCW) o dużej mocy, wymagany jest poniższy kod
  rf69.setTxPower(20, true);  // Zakres zasilania to: 14-20
  
  // Każdy węzeł musi używać tego samego klucza
  uint8_t key[] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
                    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
  rf69.setEncryptionKey(key);
  
  Serial.print("Radio RFM69 działa na częstotliwości: ");
  Serial.print((int)RF69_FREQ); Serial.println(" MHz");
}
byte message[RH_RF69_MAX_MESSAGE_LEN]; // Bufor przechowujący wiadomości z drugiego urządzenia
byte reply[] = "Do widzenia!";
void loop() 
{
  if (rf69_manager.available()) // Odebranie wiadomości
  {
    byte len = sizeof(message);
    byte sender; // ID nadawcy
    if (rf69_manager.recvfromAck(message, &len, &sender)) // Czekaj na wiadomość
    {
      message[len] = 0; // Dodanie nul (0) na końcu odpowiedzi

      Serial.print("Odebrano ["); Serial.print((char *) message);
      Serial.print("] od "); Serial.println(sender);
      
      // Mignięcie diody LED
      digitalWrite(LED_BUILTIN, HIGH); delay(250);
      digitalWrite(LED_BUILTIN, LOW); delay(250);
      
      // Odpowiedź do nadawcy
      if (!rf69_manager.sendtoWait(reply, sizeof(reply), sender))
      {
        Serial.print("Błąd wysyłania wiadomości do "); Serial.println(sender);
      }
    }
  }
}
