/*
 * Szkic lcd_special_characters
 */

#include <LiquidCrystal.h>

//Stałe przechowujące liczbę wierszy i kolumn wyświetlacza LCD
const int numRows = 2;
const int numCols = 16;

// Definicja kilku przydatnych symboli
const byte degreeSymbol = B11011111;
const byte piSymbol     = B11110111;
const byte centsSymbol  = B11101100;
const byte sqrtSymbol   = B11101000;
const byte omegaSymbol  = B11110100;  // Om

byte charCode = 32; // Pierwszy znak ASCII, który można wyświetlić
int col;
int row;

// Inicjalizacja biblioteki z podanymi numerami pinów interfejsu
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

void setup()
{
  lcd.begin(numRows, numCols);

  showSymbol(degreeSymbol, "stopień");
  showSymbol(piSymbol,     "pi");
  showSymbol(centsSymbol,  "cent");
  showSymbol(sqrtSymbol,   "pierwiastek");
  showSymbol(omegaSymbol,  "om");
  lcd.clear();

}

void loop()
{
  lcd.write(charCode);
  calculatePosition();
  if(charCode == 255)
  {
    // Ukończono wyświetlanie wszystkich znaków specjalnych, więc czekaj kilka sekund przed ponownym wyświetleniem listy
    delay(2000);
    lcd.clear();
    row = col = 0;
    charCode = 32;
  }
  charCode = charCode + 1;
}

void calculatePosition()
{
  col = col + 1;
  if( col == numCols)
  {
    col = 0;
    row = row + 1;
    if( row == numRows)
    {
      row = 0;
      delay(2000); // Przerwa
      lcd.clear();
    }
    lcd.setCursor(col, row);
  }
}

// Funkcja wyświetlająca symbol i jego opis
void showSymbol(byte symbol, char *description)
{
  lcd.clear();
  lcd.write(symbol);
  lcd.print(' '); // Dodanie spacji przed opisem
  lcd.print(description);
  delay(3000);
}
