/*
 * Szkic neo
 * Kolor diody RGB LED zmienia się zależnie od wartości analogowego pinu
 */

#include <Adafruit_NeoPixel.h>

const int sensorPin = A0; // Analogowy pin czujnika
const int ledPin = 6;     // Pin taśmy LED
const int count  = 16;     // Liczba diod LED w taśmie

// Deklaracja taśmy LED
Adafruit_NeoPixel leds = Adafruit_NeoPixel(count, ledPin, NEO_GRB + NEO_KHZ800);

void setup() {
  leds.begin(); // Inicjalizacja taśmy LED
  for (int i = 0; i < count; i++) {
    leds.setPixelColor(i, leds.Color(0,0,0)); // Wyłączenie każdej diody LED
  }
  leds.show();  // Odświeżenie taśmy LED nowymi wartościami pikseli  (wyłączenie wszystkich)
}

void loop() {
  static unsigned int last_reading = -1;

  int reading =  analogRead(sensorPin);
  if (reading != last_reading) { // Jeśli wartość się zmieniła,
    // przeskaluj odczyty analogowe do zakresu kolorów taśmy NeoPixel
    unsigned int mappedSensorReading = map(reading, 0, 1023, 0, 65535);

    // Zaktualizuj piksele z niewielkim opóźnieniem, aby stworzyć efekt pływającego światła
    for (int i = 0; i < count; i++) {
      leds.setPixelColor(i, leds.gamma32(leds.ColorHSV(mappedSensorReading, 255, 128)));
      leds.show();
      delay(25);
    }
    last_reading = reading;
  }
}
