/* 
 * Szkic tilt
 * 
 * Czujnik przechyłu podłączony do pinu 2 zapala
 * jedną z diod LED podłączonych do pinów 11 i 12
 * w zależności, od tego, w którą stronę przechylisz czujnik
 */

const int tiltSensorPin = 2;  // Pin czujnika przechyłu 
const int firstLEDPin  = 11;  // Pin diody LED
const int secondLEDPin = 12;  // Pin drugiej diody LED

void setup()
{
  pinMode (tiltSensorPin, INPUT_PULLUP); // Ustawienie czujnika przechyłu jako wejścia z aktywowanym rezystorem podciągającym

  pinMode (firstLEDPin, OUTPUT);   // Pierwsza dioda ustawiona jako wyjście
  pinMode (secondLEDPin, OUTPUT);  // Druga dioda ustawiona jako wyjście
}

void loop()
{
  if (digitalRead(tiltSensorPin) == LOW){ // Przełącznik jest włączony (skierowany do góry).
    digitalWrite(firstLEDPin, HIGH);      // Włączenie pierwszej diody LED
    digitalWrite(secondLEDPin, LOW);      // Wyłącznie drugiej
  }
  else{                                   // Przełącznik jest wyłączony (poruszony)
    digitalWrite(firstLEDPin, LOW);       // Wyłączenie pierwszej diody LED
    digitalWrite(secondLEDPin, HIGH);     // Włącznie drugiej
  }
}
