/*
   Szkic ps2_mouse
   Myszka
   Szkic Arduino korzystający z biblioteki dla myszki PS2 (http://www.arduino.cc/playground/ComponentLib/Ps2mouse)
 */

#include <ps2.h>

const int dataPin =  5;
const int clockPin = 6;

const int xLedPin  = 9; // W przypadku płytki MKR, użyj pinu 9
const int yLedPin  = 10;

const int mouseRange = 255;  // Maksymalna wartość współrzędnych x i y

char x;                 // Wartości odczytane z myszki
char y;
byte status;
  
int xPosition = 0;      // Inkrementowane i dekrementowane wartości w zależności od ruchu myszki
int yPosition = 0;
int xBrightness = 128;  // Wartości, które rosną lub maleją w zależności od pozycji myszki
int yBrightness = 128;

const byte REQUEST_DATA = 0xeb; // Polecenie odczytujące dane z myszki

PS2 mouse(clockPin, dataPin); // Deklaracja obiektu myszki

void setup()
{
  Serial.begin(9600);
  mouseBegin(); // Inicjalizacja myszki
}

void loop()
{
  // odczyt danych myszki
  mouse.write(REQUEST_DATA); // Zapytaj myszkę o dane
  mouse.read();      // Pomiń potwierdzenie

  status = mouse.read(); // Odczyt przycisków myszki
  if(status & 1) // Taki bit jest ustawiony, gdy został wciśnięty lewy przycisk myszki
    xPosition = 0; // Wyśrodkowanie pozycji x myszki
  if(status & 2) // Taki bit jest ustawiony, gdy został wciśnięty prawy przycisk myszki
    yPosition = 0; // Wyśrodkowanie pozycji y myszki

  x = mouse.read();
  y = mouse.read();
  if( x != 0 || y != 0)
  {
    // Jeśli wykryto ruch,

    xPosition = xPosition + x; // dodaj do siebie te pozycje,
    xPosition = constrain(xPosition,-mouseRange,mouseRange);

    xBrightness = map(xPosition, -mouseRange, mouseRange, 0,255);
    analogWrite(xLedPin, xBrightness);

    yPosition = constrain(yPosition + y, -mouseRange,mouseRange);
    yBrightness = map(yPosition, -mouseRange, mouseRange, 0,255);
    analogWrite(yLedPin, yBrightness);
    printValues(); // Pokaż przycisk oraz pozycję w monitorze portu szeregowego, lub Kreślarce
  }
}

void mouseBegin()
{
  // reset i inicjalizacja myszki
  mouse.write(0xff);         // Reset
  delayMicroseconds(100);
  mouse.read();              // Bajt potwierdzenia
  mouse.read();              // Puste
  mouse.read();              // Puste
  mouse.write(0xf0);         // Tryb zdalny
  mouse.read();              // Potwierdzenie
  delayMicroseconds(100);
}

void printValues()
{
  Serial.print("X:");
  Serial.print(xPosition);
  Serial.print(",Y:");
  Serial.print(yPosition);
  Serial.println();
}
