/*
   Szkic MultiRX
   Odbieranie danych z dwóch programowych portów szeregowych
*/
#include <SoftwareSerial.h>
const int rxpin1 = 8;
const int txpin1 = 9;
const int rxpin2 = 10;
const int txpin2 = 11;

SoftwareSerial gps(rxpin1, txpin1); // Urządzenie GPS podłączone do pinów 8 i 9
SoftwareSerial xbee(rxpin2, txpin2); // Urządzenie XBee podłączone do pinów 10 i 11

void setup()
{
  Serial.begin(9600);
  xbee.begin(9600);
  gps.begin(9600);
  xbee.listen(); // Ustaw “xbee” jako urządzenie aktywne
}

void loop()
{
  xbee.listen(); // Ustaw “xbee” jako urządzenie aktywne.
  if (xbee.available() > 0) // XBee jest aktywny. Czy jest dostępny jakiś znak?
  {
    if (xbee.read() == 'y') // Jeśli XBee otrzymał znak 'y',
    {
      Serial.println("Odebrałem y!");
      gps.listen(); // rozpocznij nasłuchiwanie urządzenia GPS

      unsigned long start = millis(); // Początek nasłuchiwania urządzenia GPS
      while (start + 100000 > millis())
        // nasłuchiwanie przez 10 sekund
      {
        if (gps.available() > 0) // Teraz urządzenie GPS jest aktywne
        {
          char c = gps.read();
          Serial.write(c);              // Wyświetl odebrane dane w konsoli
        }
      }
      xbee.listen(); // Po 10 sekundach ponownie rozpocznij nasłuchiwanie XBee
    }
  }
}
