/*
 * Szkic Blink w połączeniu z fotorezystorem (dostosowana częstotliwość mignięcia)
 */
const int sensorPin = A0;    // podłącz czujnik do analogowego pinu 0

// Niskie i wysokie wartości odczytów czujnika. Możliwe, że będzie potrzeba ich kalibracji.
const int low  = 200;
const int high = 800;

// kolejne dwie linijki ustawiają minimalne i maksymalne opóźnienie pomiędzy mignięciami
const int minDuration = 100;  // minimalna przerwa pomiędzy mignięciami
const int maxDuration = 1000; // maksymalna przerwa pomiędzy mignięciami

void setup()
{
  pinMode(LED_BUILTIN, OUTPUT);  // ustawienie diody LED jako wyjścia
}

void loop()
{
  int delayval = analogRead(sensorPin);    // odczytaj wejście analogowe

  // następna linijka skaluje opóźnienie pomiędzy wartością maksymalną i minimalną
  delayval = map(delayval, low, high, minDuration, maxDuration);
  delayval = constrain(delayval, minDuration, maxDuration);

  digitalWrite(LED_BUILTIN, HIGH);      // włącz diodę LED
  delay(delayval);                      // opóźnienie zależy od natężenia światła
  digitalWrite(LED_BUILTIN, LOW);       // wyłącz diodę LED
  delay(delayval);
}
