/*
 * Szkic pulse_width_duration
 * Ustawia długość i szerokość impulsów
 */

#include <TimerOne.h>

const int outPin = 9; // Numer pinu; na płytkach Teensy 3.x użyj pinów 3 – 4, a na Arduino Mega pinów 11 – 13

long period = 40; //  40-mikrosekundowa długość (25 kHz)
long width  = 20; // 20-mikrosekundowa szerokość (50% współczynnika wypełnienia impulsu)

void setup()
{
  Serial.begin(9600);
  pinMode(outPin, OUTPUT);
  Timer1.initialize(period); // Inicjalizacja Timer1, 10000 mikrosekund
  int dutyCycle = map(width, 0,period, 0,1023);
  Timer1.pwm(outPin, dutyCycle); // Funkcja PWM na pinie wyjścia
}

void loop()
{
}
