/*
 * Szkic freemem_avr
 */

String s = "\n";

void setup()
{
  Serial.begin(9600);
}

void loop()
{
  Serial.println(memoryFree());  // Wyświetlenie wolnej pamięci
  //s = s + "Witaj, jestem Arduino\n";
  Serial.println(s);           //Wyświetlenie łańcucha znaków s
  delay(3000);
}

// Zmienna utworzona przez proces kompilacji
extern int *__brkval; // Wskaźnik na ostatni zapisany adres kopca (lub 0)

// Funkcja zwracająca ilość wolnej pamięci RAM
int memoryFree()
{
  int freeValue; // Ostatni umieszczony na stosie obiekt
  if((int)__brkval == 0) // Kopiec jest pusty, zatem użyj początku kopca
  {
    freeValue = ((int)&freeValue) - ((int)__malloc_heap_start);
  }
  else // Kopiec nie jest pusty, zatem użyj ostatniego adresu kopca
  {
    freeValue = ((int)&freeValue) - ((int)__brkval);
  }
  return freeValue;
}
