/*
 * Szkic web_server_multi_page_html
 * Wyświetla wartości analogowych i cyfrowych pinów za pomocą formatowania HTML
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

const int MAX_PAGE_NAME_LEN = 11;  // Maksymalna liczba znaków w nazwie strony
char buffer[MAX_PAGE_NAME_LEN+1];  // Nazwa strony + końcowy null

void setup() {
  Serial.begin(9600);
 
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  server.begin();
  pinMode(LED_BUILTIN, OUTPUT);
  for(int i=0; i < 3; i++)
  {
     digitalWrite(LED_BUILTIN, HIGH);
     delay(500);
     digitalWrite(LED_BUILTIN, LOW);
     delay(500);
  }
}

#define MSG_DELAY 10000
void loop() {
  static unsigned long nextMsgTime = 0;
  if (millis() > nextMsgTime)
  {
    Serial.print("Odwiedź http://");
    Serial.print(getIP()); Serial.println("/analogowy/");
    nextMsgTime = millis() + MSG_DELAY;
  }

  maintain(); // Utrzymanie dzierżawy DHCP, jeśli jest to konieczne

  client = server.available();
  if (client) 
  {
    while (client.connected()) 
    {
      if (client.available()) 
      {
        if( client.find("GET ") ) 
        {
          // Wyszukanie nazwy strony
          memset(buffer,0, sizeof(buffer)); // Wyczyszczenie buforu
          if(client.find( "/"))
            if(client.readBytesUntil('/', buffer, MAX_PAGE_NAME_LEN )) 
            {
              if(strcasecmp(buffer, "analogowy") == 0)
                showAnalog();
              else if(strcasecmp(buffer, "cyfrowy") == 0)
                showDigital();
              else
                unknownPage(buffer);
            }
        }
        break;
      }
    }
    // Czas dla przeglądarki na odebranie danych
    delay(100);
    client.stop();
  }
}

void showAnalog()
{
  sendHeader("Piny analogowe");
  client.println("<h2>Piny analogowe</h2>");
  client.println("<table border='1' >");
  for (int i = 0; i < 6; i++) 
  {
    // Wyświetlenie wartości każdego analogowego pinu wejścia
    client.print("<tr><td>pin analogowy ");
    client.print(i);
    client.print(" </td><td>");
    client.print(analogRead(i));
    client.println("</td></tr>");
  }
  client.println("</table>");
  client.println("</body></html>");
}

void showDigital()
{
  sendHeader("Piny cyfrowe");
  client.println("<h2>Piny cyfrowe</h2>");
  client.println("<table border='1'>");
  for (int i = 2; i < 8; i++) 
  {
    // Wyświetlenie wartości każdego cyfrowego pinu wejścia
    pinMode(i, INPUT_PULLUP);
    digitalWrite(i, HIGH); // Włączenie rezystorów podciągających
    client.print("<tr><td>pin cyfrowy ");
    client.print(i);
    client.print(" </td><td>");
    if(digitalRead(i) == LOW)
      client.print("Wysoki");
    else
      client.print("Niski");
    client.println("</td></tr>");
  }
  client.println("</table>");
  client.println("</body></html>");
}

void unknownPage(char *page)
{
  sendHeader("Strona nieznana");
  client.println("<h1>Strona nieznana</h1>");
  client.print(page);
  client.println("<br />");
  client.println("Rozpoznane strony to:<br />");
  client.println("/analogowy/<br />");
  client.println("/cyfrowy/<br />"); 
  client.println("</body></html>");
}

void sendHeader(char *title)
{
  // Wysłanie standardowego nagłówka odpowiedzi HTTP
  client.println("HTTP/1.1 200 OK");
  client.println("Typ zawartości: text/html");
  client.println();
  client.print("<html><head><title>");
  client.println(title);
  client.println("</title><body>");
}
