/*
 *  Szkic mqtt_publish
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

#include <PubSubClient.h>

const char* broker = "mqtt.eclipse.org"; // Adres brokera MQTT

const int interval = 5000;   // Liczba milisekund między wydarzeniami
unsigned int timePublished;  // Czas, który upłynął od ostatniej publikacji

PubSubClient psclient(client);

void setup()
{
  Serial.begin(9600);
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while (1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  psclient.setServer(broker, 1883);
}

void loop(void)
{
  if (millis() - timePublished > interval) 
  {
    if (!psclient.connected())
      psclient.connect("arduinoCookbook3Pub");
    if (psclient.connected()) 
    {
      int val = analogRead(A0);
      psclient.publish("arck3/alog", String(val).c_str());
      timePublished = millis();
      Serial.print("Opublikowano "); Serial.println(val);
    }
  }
  if (psclient.connected())
    psclient.loop();
}
