/*
* Szkic tmp36
* Wyświetla temperaturę w monitorze portu szeregowego
* i zapala diodę LED po przekroczeniu wartości progowej
*/
const int inPin = A0; // pin analogowy
const int ledPin = LED_BUILTIN;
const int threshold = 80; // Zapal diodę LED powyżej 80 F
void setup()
{
  Serial.begin(9600);
}

void loop()
{
  int value = analogRead(inPin);
  // Dla płytek 3,3 V użyj 3300 zamiast 5000
  float millivolts = (value / 1024.0) * 5000;
  // 10mV na stopień Celsjusza z korektą równą 500 mv
  float celsius = (millivolts - 500) / 10;
  float fahrenheit = (celsius * 9)/ 5 + 32;
  Serial.print("C:");
  Serial.print(celsius);
  Serial.print(",");
  Serial.print("F:");
  Serial.println( fahrenheit ); // Zamiana na Fahrenheity
  
  if (fahrenheit > threshold){ // Czy temperatura przekroczyła wartość progową?
    digitalWrite(ledPin, HIGH); // Jeśli tak, zapal diodę LED,
  } else {
    digitalWrite(ledPin, LOW); // a jeśli nie, zgaś diodę LED.
  }
  delay(1000); // 1-sekundowa pauza
}
