/* szkic Rotary_Interrupt_TwoFer
 * Przykład z dwoma enkoderami
 * Odczytuje dane z enkodera przyrostowego za pomocą biblioteki wykorzystującej przerwania.
 */

#include <Encoder.h>

Encoder myEncA(2, 3); // Na płytkach MKR, użyj pinów 4, 5.
Encoder myEncB(6, 7); // Na płytkach Mega, użyj pinów 18, 19

void setup()
{
  Serial.begin(9600);
  while(!Serial);
}

long lastA  = -999;
long lastB  = -999;

void loop()
{
  long currentA = myEncA.read();
  long currentB = myEncB.read();
  if (currentA != lastA || currentB != lastB) { // Jeśli, któraś z pozycji uległa zmianie,
    lastA = currentA; // zapisz obie.
    lastB = currentB;

    // Wyświtel pozycje w monitorze portu szeregowego (lub Kreślarce) 
    Serial.print("A:"); Serial.print(currentA);
    Serial.print(" ");
    Serial.print("B:"); Serial.println(currentB);
  }
}
