/*
 * Szkic SendBinaryFields
 * Wysyła wartości pinów analogowych i cyfrowych w postaci binarnej
 */

const char HEADER = 'H';  // Pojedynczy znak nagłówka wskazujący na początek wiadomości


void setup()
{
  Serial.begin(9600);
  for(int i=2; i <= 13; i++)
  {
    pinMode(i, INPUT_PULLUP);       // Ustawienie pinów od 2 do 13 jako wejścia
    digitalWrite(i, HIGH);   // Włączenie stanu wysokiego na pinach od 2 do 13
  }
}

void loop()
{
  Serial.write(HEADER); // Wysłanie nagłówka
  // Wpisanie wartości pinów w postaci bitów do liczby całkowitej
  int values = 0;
  int bit = 0;

  for(int i=2; i <= 13; i++)
  {
    bitWrite(values, bit, digitalRead(i));  // Ustawienie pinu na 0 lub 1 w zależności od wartości danego pinu
    bit = bit + 1;                          // Przejście do kolejnego bitu
  }
  sendBinary(values); // Wysłanie liczby całkowitej

  for(int i=0; i < 6; i++)
  {
    values = analogRead(i);
    sendBinary(values); // Wysłanie liczby całkowitej
  }
  delay(1000); //Wysyłanie co 1 sekundę
}

// Funkcja wysyłająca podaną liczbę całkowitą do portu szeregowego
void sendBinary(int value)
{
  // Wysłanie 2 bajtów składających się na liczbę całkowitą
  Serial.write(lowByte(value));  // Wysłanie dolnego bajtu
  Serial.write(highByte(value)); // Wysłanie górnego bajtu
}
