/*
 * Przykład z wartością zmiennoprzecinkową
 * Szkic inicjalizuje wartość zmiennoprzecinkową równą 1,1,
 * a następnie stopniowo ją redukuje o 0,1, aż do momentu, gdy zmienna osiągnie wartość 0.
 */

float value = 1.1;

void setup()
{
  Serial.begin(9600);
}

void loop()
{
  value = value - 0.1;   // Zmniejszenie wartości o 0,1 przy każdym obiegu pętli
  if( value == 0)
  {
     Serial.println("Wartość wynosi dokładnie zero");
  }
  else if(almostEqual(value, 0))
  {
    Serial.print("Wartość ");
    Serial.print(value,7); // Wyświetlanie z dokładnością do 7 miejsc po przecinku
    Serial.println(" jest niemal równa zero, ponowne odliczanie");
    value = 1.1;
  }
  else 
  {
    Serial.println(value);
  }
  delay(250);
}
      
// Zwraca true, gdy różnica między a i b jest mała
bool almostEqual(float a, float b)
{  
  const float DELTA = .00001; // Maksymalna różnica, aby wartości były niemal równe 
  if (a == 0) return fabs(b) <= DELTA;
  if (b == 0) return fabs(a) <= DELTA;
  return fabs((a - b) / max(fabs(a), fabs(b))) <= DELTA;
}
