/*
  blink3 sketch
  Pokazuje przykład funkcji pobierającej parametr i zwracającej wartość
  
  Dioda LED miga na początku programu i przestaje, gdy przycisk podłączony do cyfrowego pinu 2 jest wciśnięty
  Program wyświetla informacje o tym, ile razy dioda LED mignęła
 */

const int inputPin = 2;         // Pin wejścia dla przycisku

void setup() {
  pinMode(LED_BUILTIN, OUTPUT);
  pinMode(inputPin, INPUT);
  digitalWrite(inputPin,HIGH); // Wykorzystanie wbudowanych rezystorów podciągających (receptura 5.2)
  Serial.begin(9600);
}

void loop(){
  Serial.println("Naciśnij i przytrzymaj przycisk, aby didoa LED przestała migać.");
  int count = blink3(250); // Migaj diodą LED z częstotliwością 250 ms
  Serial.print("Liczba mignięć diody LED to: ");
  Serial.println(count);
  while(digitalRead(inputPin) == LOW)
  {
    // Nic nie rób, dopóki przycisk nie zostanie zwolniony
  }
}

// Miganie diodą LED z podaną częstotliwością
// Zwróć liczbę mignięć
int blink3(int period)
{
  int blinkCount = 0;

  while(digitalRead(inputPin) == HIGH) // Powtarzaj, dopóki przycisk nie zostanie wciśnięty
                                       // (po wciśnięciu zmieni stan na niski)
  {
    digitalWrite(LED_BUILTIN, HIGH);
    delay(period);
    digitalWrite(LED_BUILTIN, LOW);
    delay(period);
    blinkCount = blinkCount + 1; // Zwiększ wartość zmiennej blinkCount o 1
  }
  // Zwróć wartość, jeżeli inputPin nie ma już wartości HIGH (co oznacza, że został wciśnięty)
  return blinkCount;  // Wartość, która zostanie zwrócona
}
