//Przesyłanie danych pogodowych do serwisu ThingSpeak

// Biblioteki
#include <Adafruit_CC3000.h>
#include <SPI.h>
#include <avr/wdt.h> //biblioteka watchdoga

// Deklaracja pinów połączonych z chipem CC3000
#define ADAFRUIT_CC3000_IRQ   3
#define ADAFRUIT_CC3000_VBAT  5
#define ADAFRUIT_CC3000_CS    10

// Czujnik prądu (nr pinu)
#define CURRENT_SENSOR A0

// Zmienne potrzebne do obliczania mocy pobieranego prądu
float amplitude_current;
float effective_value;
float effective_voltage = 230; // Ustaw napięcie 230V (Europa) lub 110V (USA)
float effective_power;
float zero_sensor;

// Instancja CC3000
Adafruit_CC3000 cc3000 = Adafruit_CC3000(ADAFRUIT_CC3000_CS, ADAFRUIT_CC3000_IRQ, ADAFRUIT_CC3000_VBAT,
SPI_CLOCK_DIV2); // tę szybkość zegara można zmieniać

// Parametry WLAN
#define WLAN_SSID       "twój SSID"
#define WLAN_PASS       "twoje hasło"

#define WLAN_SECURITY   WLAN_SEC_WPA2

// Klucz API serwisu ThingSpeak
String writeAPIKey = "klucz Write API Key";

uint32_t ip; //IP serwisu ThingSpeak

// Zmienne potrzebne do obsługi nieudanych prób przesłania danych do serwisu
long lastConnectionTime = 0; 
boolean lastConnected = false;
int failedCounter = 0;


void setup(void)
{
  // Inicjalizacja portu szeregowego
  Serial.begin(115200);
  
  // Kalibrowanie czujnika prądu
  zero_sensor = 512.35; // Zamiast kalibracji wpisujemy wartość ustaloną eksperymentalnie - przyp. tłum
  //zero_sensor = getSensorValue(); 
  Serial.print("Punkt zerowy czujnika: ");
  Serial.println(zero_sensor);
  Serial.println("");
  
  //Inicjalizacja instancji klasy CC3000
  Serial.println(F("\nZaczynam..."));
  if (!cc3000.begin())
  {
    Serial.println(F("Nie moge zaczac()! Sprawdz kabelki?"));
    while(1);
  }
  // Połączenie z siecią WiFi
  cc3000.connectToAP(WLAN_SSID, WLAN_PASS, WLAN_SECURITY);
  Serial.println(F("Jest Wi-Fi!"));

  // Jeszcze tylko żądanie DHCP
  Serial.println(F("Zapytanie DHCP"));
  while (!cc3000.checkDHCP())
  {
    delay(100);
  } 
  Serial.println("DHCP OK"); 
}

void loop(void)
{
  // Odczyt i wyświetlenie bieżącego pomiaru
  float sensor_value = getSensorValue();
  Serial.print("Wartość odczytana z czujnika: ");
  Serial.println(sensor_value);
  
  // Obliczanie natężenia i mocy prądu
  amplitude_current=(float)(sensor_value-zero_sensor)/1024*5/185*1000000;
  effective_value=amplitude_current/1.414;
  effective_power = abs(effective_value*effective_voltage/1000);
    
  //Przygotowanie danych do wysłania
  String ev=String(effective_value, DEC); //Strumień danych dla ThingSpeak może być tylko łańcuchowy
  String ep=String(effective_power, DEC);    // Dlatego potrzebna jest konwersja danych na łańcuchy
  String evpData="1="+ev+"&2="+ep;
  
  Serial.print(F("api.thingspeak.com -> "));
  while  (ip  ==  0)  {
    if  (!  cc3000.getHostByName("api.thingspeak.com", &ip))  {
      Serial.println(F("Nie udalo sie!, Zaczynam od nowa....."));
      wdt_enable(WDTO_8S);                  // jeśli host nie odpowiada czekaj 8 s i zacznij od nowa
      while(1){}
    }
    
    delay(500);
  }  

  cc3000.printIPdotsRev(ip); //nadaj adresowi IP postać z kropkami
  Serial.println(F("")); 
  
   // Próba polączenia z serwisem ThingSpeak
  Adafruit_CC3000_Client client = cc3000.connectTCP(ip, 80);
   
  if (client.available()){
      char c = client.read();
      Serial.print(c);
  }
 
  
 // Wysyłanie danych do kanału ThingSpeak
  if(client.connected()) 
  {
    updateThingSpeak(evpData);  // funkcja wysyłająca dane
    delay(30000);   // ThingSpeak wymaga co najmniej 15 s przerwy między kolejnymi strumieniami (tu jest 0,5 min). 
    failedCounter=0;

  }
  else
  {
  Serial.println(F("Polonczenie nieudalo sie"));
  failedCounter++;
  if (failedCounter==10)
  {
    Serial.println(F("Polonczenie nie udalo sie 10 razy, Zaczynam od nowa......"));
    wdt_enable(WDTO_8S);   // Po dziesięciu kolejnych nieudanych próbach wysłania danych, wszystko zacznie się od nowa.
    while(1){}
  }
  }
  
  
 
}

void updateThingSpeak(String cpData)
{
    Adafruit_CC3000_Client client = cc3000.connectTCP(ip, 80);
    Serial.println("Laczenie z ThingSpeak...");
    Serial.println("Wysylanie danych");
    client.print("POST /update HTTP/1.1\n");
    client.print("Host: api.thingspeak.com\n");
    client.print("Connection: close\n");
    client.print("X-THINGSPEAKAPIKEY: "+writeAPIKey+"\n");
    client.print("Content-Type: application/x-www-form-urlencoded\n");
    client.print("Content-Length: ");
    client.print(cpData.length());
    client.print("\n\n");
    client.print(cpData);
    Serial.println(F("Gotowe"));
    Serial.println(F("Czekam 30 s do nast. transmisji"));
}

// Bieżący odczyt z czujnika
float getSensorValue()
{
  // Te trzy zmienne posłużą do zapamietania trzech kolejnych odczytów
  int sensorValue1; 
  int sensorValue2;
  int sensorValue3;
  // Zmienna sensorValue będzie zawierała wartość średnią tych trzech odczytów
  float sensorValue;
  int nb_measurements = 100;
  //Zmienna avgSensor otrzyma ostatecznie wartość maksymalną (amplitudę) warości zmiennej sensorValue
  float avgSensor = zero_sensor;
    for (int i = 0; i < nb_measurements; i++) {
      sensorValue1 = analogRead(CURRENT_SENSOR);
      sensorValue2 = analogRead(CURRENT_SENSOR);
      sensorValue3 = analogRead(CURRENT_SENSOR);
      sensorValue = (sensorValue1+sensorValue2+sensorValue3)/3.0;
      if (avgSensor < sensorValue)
      {
        avgSensor = float(sensorValue);
      }
    }
  return avgSensor;
}

