// Szkic sterujący działaniem przekaźnika i modułu WiFi

// Import niezbędnych bibliotek
#include <Adafruit_CC3000.h>
#include <SPI.h>
#include <CC3000_MDNS.h>
#include <aREST.h>

// To są numery pinów do podłączenia modułu z chipem CC3000 
#define ADAFRUIT_CC3000_IRQ   3
#define ADAFRUIT_CC3000_VBAT  5
#define ADAFRUIT_CC3000_CS    10

// Utwórz instancję CC3000 
Adafruit_CC3000 cc3000 = Adafruit_CC3000(ADAFRUIT_CC3000_CS, ADAFRUIT_CC3000_IRQ, ADAFRUIT_CC3000_VBAT,
                                         SPI_CLOCK_DIV2);
// Utwórz instancję ArduREST 
aREST rest = aREST();

// Twoje SSID i hasło WiFi                                      
#define WLAN_SSID       "yourSSID"
#define WLAN_PASS       "yourPassword"
#define WLAN_SECURITY   WLAN_SEC_WPA2

// Port do nasłuchiwania przychodzących połączeń TCP 
#define LISTEN_PORT           80

// Instancja serwera
Adafruit_CC3000_Server restServer(LISTEN_PORT);

// Instancja respondera DNS
MDNSResponder mdns;

void setup(void)
{
  // Uruchom połączeneie szeregowe
  Serial.begin(115200);
  
  // Ustaw CC3000 i połącz go z siecią bezprzewodową.
  if (!cc3000.begin())
  {
    while(1);
  }
  if (!cc3000.connectToAP(WLAN_SSID, WLAN_PASS, WLAN_SECURITY)) {
    while(1);
  }
  while (!cc3000.checkDHCP())
  {
    delay(100);
  }
  Serial.println();
  
  // Wyświetl adres IP modułu CC3000 
  while (! displayConnectionDetails()) {
    delay(1000);
  }
  
  // Uruchom responder DNS 
  if (!mdns.begin("arduino", cc3000)) {
    while(1); 
  }
   
  // Uruchom serwer
  restServer.begin();
  Serial.println(F("Nasluchiwanie polonczen..."));
}

void loop() {
  
  // Obsługa żądań DNS
  mdns.update();
  
  // Obsługa wywołań REST
  Adafruit_CC3000_ClientRef client = restServer.available();
  rest.handle(client);
 
}

// Wyświetl szczegóły połączenia chipu CC3000 
bool displayConnectionDetails(void)
{
  uint32_t ipAddress, netmask, gateway, dhcpserv, dnsserv;
  
  if(!cc3000.getIPAddress(&ipAddress, &netmask, &gateway, &dhcpserv, &dnsserv))
  {
    Serial.println(F("Unable to retrieve the IP Address!\r\n"));
    return false;
  }
  else
  {
    Serial.print(F("\nIP Addr: ")); cc3000.printIPdotsRev(ipAddress);
    Serial.print(F("\nNetmask: ")); cc3000.printIPdotsRev(netmask);
    Serial.print(F("\nGateway: ")); cc3000.printIPdotsRev(gateway);
    Serial.print(F("\nDHCPsrv: ")); cc3000.printIPdotsRev(dhcpserv);
    Serial.print(F("\nDNSserv: ")); cc3000.printIPdotsRev(dnsserv);
    Serial.println();
    return true;
  }
}
