#include <Ethernet.h>
#include <SPI.h>   

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; //Fizyczny adres MAC.

char smtp[] = "smtpcorp.com";
int port = 2525;
char fromEmail[] = "mojadres@jakisadres.com";
char toEmail[] = "mojadres@jakisadres.com";
char emailBase64[] = "hasdfgw456hg56=";
char passwordBase64[] = "hjgwrejtgwrejt=";
char message[] = "Wcisnieto przycisk";

EthernetClient client;

// Piny połączone z odbiornikiem.
int gndPin = A3;
int plusPin = A5;
int vtPin = A4;

void setup()
{
  pinMode(gndPin, OUTPUT);
  digitalWrite(gndPin, LOW);
  pinMode(plusPin, OUTPUT);
  digitalWrite(plusPin, HIGH);
  pinMode(vtPin, INPUT);
  pinMode(A0, INPUT);
  pinMode(A1, INPUT);
  pinMode(A2, INPUT);
  Serial.begin(9600);
  while (!Serial) {};
  Serial.println("Gotowy");
}

void loop()
{
  if (digitalRead(vtPin))
  {
    Serial.println("Aktywowano wysylanie wiadomosci e-mail.");
    connectToNetwork();  
    connectToMailServer();
    sendMessage(message);
    if (!client.connected()) 
    {
      Serial.println("Rozlaczanie.");
      client.stop();
    }
    delay(3000);
  }
  displayClientResponse();
}

void connectToNetwork()
{
  if (Ethernet.begin(mac))
  {
    Serial.println("Nawiazano polaczenie z serwerem DHCP");
    for (byte thisByte = 0; thisByte < 4; thisByte++)
    {
      Serial.print(Ethernet.localIP()[thisByte], DEC);
      Serial.print("."); 
    }
  }
  delay(3000);
  Serial.println();
}

void connectToMailServer()
{
  Serial.println("Nawiazywanie polaczenia z serwerem SMTP");
  if (client.connect(smtp, port)) 
  {
    Serial.println("Nawiazano polaczenie z serwerem SMTP");
    delay(500);
  } 
  else 
  {
    Serial.println("Nie nawiazano polaczenia z serwerem SMTP");
  }
}

void sendMessage(char message[])
{
    client.println("EHLO kltan");
    client.println("AUTH LOGIN");                        
    client.println(emailBase64);          
    client.println(passwordBase64);                                              
    client.print("MAIL FROM:");
    client.println(fromEmail);
    client.print("RCPT TO:");
    client.println(toEmail);
    client.println("DATA");
    client.print("from:");
    client.println(fromEmail);
    client.print("to:");
    client.println(toEmail);
    client.println("SUBJECT: Testowanie");
    client.println();
    client.println(message);
    client.println(".");
    client.println("QUIT");
}

void displayClientResponse()
{
  if (client.available()) 
  {
    char c = client.read();
    Serial.print(c);
  }
}
