
// Arduino Uno R3 lub Leonardo (z płytką rozszerzeń Ethernet)

#include <SPI.h>
#include <Ethernet.h>

// Adres MAC musi być unikalny (domyślna wartość nie powinna powodować problemów).
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
// Adres IP zależy od Twojej sieci.
EthernetServer server(80);

int relayPin = 2;

char line1[100];

void setup()
{
  Serial.begin(9600);
  while (!Serial){};
  pinMode(relayPin, OUTPUT);
  connectToNetwork();
  server.begin();
}

void connectToNetwork()
{
  if (Ethernet.begin(mac))
  {
    for (byte thisByte = 0; thisByte < 4; thisByte++)
    {
      Serial.print(Ethernet.localIP()[thisByte], DEC);
      Serial.print("."); 
    }
  }
  delay(3000);
}

void loop()
{
  EthernetClient client = server.available();
  if (client) 
  {
    while (client.connected()) 
    {
      readHeader(client);
      if (! pageNameIs("/"))
      {
        client.stop();  
        return;
      }
      digitalWrite(relayPin, valueOfParam('a'));
      client.println("HTTP/1.1 200 OK");
      client.println("Content-Type: text/html");
      client.println();

      // Prześlij treść.
      client.println("<html><body>");
      client.println("<h1>Zdalne sterowanie</h1>");

      client.println("<h2><a href='?a=1'/>Aktywne</a></h2>");
      client.println("<h2><a href='?a=0'/>Nieaktywne</a></h2>");
      client.println("</body></html>");

      client.stop();            
    }
  }
}


void readHeader(EthernetClient client)
{
  // Wczytaj pierwszą linię nagłówka.
  char ch;
  int i = 0;
  while (ch != '\n')
  {
    if (client.available())
    {
      ch = client.read();
      line1[i] = ch;
      i ++;
    }
  }
  line1[i] = '\0'; 
  Serial.println(line1);
}

boolean pageNameIs(char* name)
{
   // Nazwa strony rozpoczyna się od 4. znaku,
   // a kończy się spacją.
   int i = 4;
   char ch = line1[i];
   while (ch != ' ' && ch != '\n' && ch != '?')
   {
     if (name[i-4] != line1[i])
     {
       return false;
     }
     i++;
     ch = line1[i];
   }
   return true;
}

int valueOfParam(char param)
{
  for (int i = 0; i < strlen(line1); i++)
  {
    if (line1[i] == param && line1[i+1] == '=')
    {
      return (line1[i+2] - '0');
    }
  }
  return 0;
}

