
#include "Wire.h"
#include <Deuligne.h>
#include <SoftwareSerial.h>

const int rxPin = 7;
const int txPin = 8; // nieużywany
const int sentenceSize = 80;
char sentence[sentenceSize];


Deuligne lcd;
SoftwareSerial gps(rxPin, txPin); 

void setup() 
{
  lcd.init();
  gps.begin(9600);
  lcd.clear();
  lcd.print("Uruchamianie...");
  Serial.begin(9600);
}

void loop() 
{
  static int i = 0;
  if (gps.available())
  {
    char ch = gps.read();
    if (ch != '\n' && i < sentenceSize)
    {
      sentence[i] = ch;
      i++;
    }
    else
    {
     sentence[i] = '\0';
     i = 0;
     displayGPS();
    }
  }
}

void displayGPS()
{
  Serial.println(sentence);
  char field[80];
  getField(field, 0);
  if (strcmp(field, "$GPRMC") == 0)
  {
    lcd.setCursor(0, 0);
    lcd.print("Szer.: ");
    getField(field, 3);  // liczba
    lcd.print(field);
    getField(field, 4); // północ-południe
    lcd.print(field);
    
    lcd.setCursor(0, 1);
    lcd.print("Dlug.: ");
    getField(field, 5);  // liczba
    lcd.print(field);
    getField(field, 6);  // wschód-zachód
    lcd.print(field);
  }
}

void getField(char* buffer, int index)
{
  int sentencePos = 0;
  int fieldPos = 0;
  int commaCount = 0;
  while (sentencePos < sentenceSize)
  {
    if (sentence[sentencePos] == ',')
    {
      commaCount ++;
      sentencePos ++;
    }
    if (commaCount == index)
    {
      buffer[fieldPos] = sentence[sentencePos];
      fieldPos ++;
    }
    sentencePos ++;
  }
  buffer[fieldPos] = '\0';
}
