

#include <Adafruit_GFX.h>
#include <Adafruit_ST7735.h>
#include <SPI.h>

Adafruit_ST7735 tft = Adafruit_ST7735(10, 8, -1);
//                                    TFT_CS, TFT_DC, TFT_RST

const int w = 20;
const int h = 16;

const int initialPopulation = 70;

byte board[2][w][h];
byte g = 0;


void setup(void) 
{
  // Dostawca matrycy 1.8" zmienił jej specyfikację po 10 stycznia 2012 r.
  // W związku z tym wyrównanie matrycy musiało zostać przesunięte o kilka pikseli.
  // Wiąze się z tym konieczność modyfikacji kodu. Właściwy kod 
  // inicjalizujący wyswietlacz doberz na podstawie koloru etykiety. Jeżeli ekran nie wyswietla całego obracu
  // lub wyświetla piksele, których nie powinno być na ekranie, 
  // to wypróbuj inną opcję!
  // Jeżeli widzisz, że kolor zielony jest zmaieniony z kolorem czerwonym, to zainicjuj ekran tak, jakby był oznaczony czarną etykietą

  // Jeżeli foliowa osłona ekranu jest oznaczona czarną etykietą, to zasatosuj następujący kod:
  tft.initR(INITR_BLACKTAB);   // Inicjalizuje czip ST7735S oznaczony czarną etykietą.
  // IJeżeli foliowa osłona ekranu jest oznaczona czerwoną etykietą, to zasatosuj następujący kod:
  //tft.initR(INITR_REDTAB);   // Inicjalizuje czip ST7735S oznaczony czerwoną etykietą.
  // Jeżeli foliowa osłona ekranu jest oznaczona zieloną etykietą, to zasatosuj następujący kod:
  //tft.initR(INITR_GREENTAB); // Inicjalizuje czip ST7735S oznaczony zieloną etykietą.

  tft.fillScreen(0x0000);
  tft.setRotation(3);
  seedRandomGeneration();
  Serial.begin(9600);
}

void seedRandomGeneration()
{
  randomSeed(analogRead(A1));
  for (byte i=0; i < initialPopulation; i++)
  {
    int x = random(w);
    int y = random(h);
    board[g][x][y] = 1;
  }
}

void displayBoard()
{
  tft.fillScreen(0x0000);
  for (int x = 0; x < w; x++)
  {
    for (int y = 0; y < h; y++)
    {
      if (board[g][x][y])
      {
       tft.fillRect(x * 8, y * 8, 8, 8, ST7735_YELLOW);
      }
    }
  }
}

void loop() 
{
  if (analogRead(A3) < 512)
  {
    displayBoard();
    updateGeneration();
    g = !g;
  }
}

void updateGeneration()
{
  for (int x = 0; x < w; x++)
  {
    for (int y = 0; y < h; y++)
    {
      board[!g][x][y] = updateCell(x, y);
    }
  }
}

byte updateCell(int x, int y)
{
  int n = numNeighbors(x, y);
  if (board[g][x][y] == 1)
  {
    if (n < 2) return 0;
    else if (n == 2 || n == 3) return 1;
    else if (n > 3) return 0;
  }
  else
  {
    return (n == 3);
  }
}

int numNeighbors(int x, int y)
{
  int n = 0;
  for (int dx = -1; dx <= 1; dx++)
  {
    for (int dy = -1; dy <= 1; dy++)
    {
      int x1 = x + dx;
      int y1 = y + dy;
      boolean middle = (dx == 0 && dy == 0);
      if (!middle && x1 > 0 && x1 < w && y1 > 0 && y1 < h)
      {
        n += board[g][x1][y1];
      }
    }
  }
  Serial.print(n);
  return n;
}



