#include "Timer.h"

Timer t;

const int pinA = 2;
const int pinB = 3;

const int pulseLen = 30;

int event;

void setup()
{
  Serial.begin(9600);
  while (!Serial) {};
  Serial.println("Okresl szybkosc. Podaj wartosc z zakresu 0-9, gdzie 5 jest normalna szybkoscia, a 0 zatrzymuje mechanizm");
  pinMode(pinA, OUTPUT);
  pinMode(pinB, OUTPUT);
  setTickRate(5);
}

void loop()
{
  if (Serial.available())
  {
    int speed = Serial.parseInt();
    setTickRate(speed);
  }
  t.update();
}

void pulse()
{
  static int state;
  pulse(state, !state);
  state = ! state;
}


void pulse(int a, int b)
{
  digitalWrite(pinA, a);
  digitalWrite(pinB, b);
  delay(pulseLen);
  digitalWrite(pinA, LOW);
  digitalWrite(pinB, LOW);
}

void setTickRate(int rate)
{
  // Szybkość jest określana za pomocą wartości z zakresu 0-9, gdzie 5 jest normalną szybkością, a 0 zatrzymuje mechanizm.
  int period = 5000 / rate;
  t.stop(event);
  if (rate > 0)
  {
    event = t.every(period, pulse);
  }
}
