#include <LiquidCrystal.h>


const int buzzerPin = 11;
const int backlightPin = 10;
const int switchPin = A0;
const int pirPin = 2;     


//                RS,E,D4,D5,D6,D7         
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);
boolean silent = false;

void setup() 
{
  // Z powodu wad wielu tanich wyświetlaczy LCD,
  // podświetlenie ekranu sterowane za pomocą tranzystora i złącza D10 
  // może doprowadzić do uszkodzenia złącza płytki Arduino.
  pinMode(backlightPin, INPUT);
  pinMode(pirPin, INPUT);       
}

void loop() 
{
  checkPIR();                    
  if (analogRead(switchPin) < 1000) // wciśnięcie dowolnego przycisku
  {
    silent = ! silent;
    if (silent) noTone(buzzerPin);
    delay(300);
  }
  delay(100);
}

void checkPIR()
{
  boolean zombies = digitalRead(pirPin);
  if (zombies)
  {
    if (! silent)
    {
      tone(buzzerPin, 1000);
    }
    lcd.setCursor(0, 1);
    lcd.print("ZOMBIE!!!");
  }
  else
  {
    lcd.setCursor(0, 1);
    lcd.print("         ");    
  }
  if (silent)
  {
   lcd.setCursor(12, 0);
   lcd.print("WYC.");
  }
  else
  {
   lcd.setCursor(12, 0);
   lcd.print("    ");
  }  
}




