<?php


/**
 * This class adds structure of 'przydzial' table to 'angaze' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    angaze.map
 */
class PrzydzialMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'angaze.map.PrzydzialMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(PrzydzialPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(PrzydzialPeer::TABLE_NAME);
		$tMap->setPhpName('Przydzial');
		$tMap->setClassname('Przydzial');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('PRZYDZIAL_ID', 'PrzydzialId', 'INTEGER', true, null);

		$tMap->addColumn('NUMERGRUPY', 'Numergrupy', 'INTEGER', false, null);

		$tMap->addColumn('NAZWA_ALTERNATYWNA', 'NazwaAlternatywna', 'INTEGER', false, null);

		$tMap->addForeignKey('PRACOWNIK_ID', 'PracownikId', 'INTEGER', 'pracownik', 'PRACOWNIK_ID', false, null);

		$tMap->addForeignKey('PRZEDMIOT_ID', 'PrzedmiotId', 'INTEGER', 'przedmiot', 'PRZEDMIOT_ID', false, null);

	} // doBuild()

} // PrzydzialMapBuilder
