<?php


/**
 * This class adds structure of 'przedmiot' table to 'angaze' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    angaze.map
 */
class PrzedmiotMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'angaze.map.PrzedmiotMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(PrzedmiotPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(PrzedmiotPeer::TABLE_NAME);
		$tMap->setPhpName('Przedmiot');
		$tMap->setClassname('Przedmiot');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('PRZEDMIOT_ID', 'PrzedmiotId', 'INTEGER', true, null);

		$tMap->addColumn('NAZWA', 'Nazwa', 'VARCHAR', false, 255);

		$tMap->addColumn('SKROT', 'Skrot', 'VARCHAR', false, 128);

		$tMap->addColumn('GODZ', 'Godz', 'INTEGER', false, null);

		$tMap->addColumn('ZAL', 'Zal', 'VARCHAR', false, 20);

		$tMap->addColumn('LICZBAGRUP', 'Liczbagrup', 'INTEGER', false, null);

		$tMap->addColumn('SEMESTR', 'Semestr', 'INTEGER', false, null);

		$tMap->addColumn('ROK', 'Rok', 'INTEGER', false, null);

		$tMap->addColumn('ODBYWA_SIE', 'OdbywaSie', 'INTEGER', false, null);

		$tMap->addColumn('NAZWA_ALTERNATYWNA', 'NazwaAlternatywna', 'VARCHAR', false, 45);

		$tMap->addColumn('ZIMALATO', 'Zimalato', 'INTEGER', false, null);

		$tMap->addForeignKey('RODZAJZAJEC_ID', 'RodzajzajecId', 'INTEGER', 'rodzajzajec', 'RODZAJZAJEC_ID', false, null);

		$tMap->addForeignKey('KIERUNEK_ID', 'KierunekId', 'INTEGER', 'kierunek', 'KIERUNEK_ID', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

	} // doBuild()

} // PrzedmiotMapBuilder
