set names utf8;
drop database if exists panstwa_miasta;
create database panstwa_miasta default character set utf8 collate utf8_polish_ci;
grant all on panstwa_miasta.* to admin@localhost identified by 'password';
flush privileges;
use panstwa_miasta;


CREATE TABLE panstwo (panstwo_id INT AUTO_INCREMENT, nazwa VARCHAR(45), slug VARCHAR(45), kontynent_id INT, INDEX kontynent_id_idx (kontynent_id), PRIMARY KEY(panstwo_id)) ENGINE = InnoDB;
CREATE TABLE miasto (miasto_id INT AUTO_INCREMENT, nazwa VARCHAR(45), slug VARCHAR(45), panstwo_id INT, INDEX panstwo_id_idx (panstwo_id), PRIMARY KEY(miasto_id)) ENGINE = InnoDB;
CREATE TABLE kontynent (kontynent_id INT AUTO_INCREMENT, nazwa VARCHAR(45), slug VARCHAR(45), PRIMARY KEY(kontynent_id)) ENGINE = InnoDB;
ALTER TABLE panstwo ADD CONSTRAINT panstwo_kontynent_id_kontynent_kontynent_id FOREIGN KEY (kontynent_id) REFERENCES kontynent(kontynent_id);
ALTER TABLE miasto ADD CONSTRAINT miasto_panstwo_id_panstwo_panstwo_id FOREIGN KEY (panstwo_id) REFERENCES panstwo(panstwo_id);
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 08:33
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `panstwa_miasta`
--

--
-- Zrzut danych tabeli `kontynent`
--

INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(1, 'Ameryka Południowa', 'ameryka_poludniowa');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(2, 'Europa', 'europa');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(3, 'Azja', 'azja');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(4, 'Afryka', 'afryka');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(5, 'Ameryka Północna', 'ameryka_polnocna');
INSERT INTO `kontynent` (`kontynent_id`, `nazwa`, `slug`) VALUES(6, 'Australia', 'australia');

--
-- Zrzut danych tabeli `miasto`
--

INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(1, 'Cozoco', 'cozoco', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(2, 'Plura', 'plura', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(3, 'Lima', 'lima', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(4, 'Juliaca', 'juliaca', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(5, 'Tumbes', 'tumbes', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(6, 'Grocio', 'grocio', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(7, 'Jaen', 'jaen', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(8, 'Trujillo', 'trujillo', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(9, 'Talara', 'talara', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(10, 'Moquequa', 'moquequa', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(11, 'Ciclayo', 'ciclayo', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(12, 'Huacho', 'huacho', 1);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(13, 'St. Polten', 'st_polten', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(14, 'Leoben', 'leoben', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(15, 'Steyr', 'steyr', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(16, 'Schwechat', 'schwechat', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(17, 'Landeck', 'landeck', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(18, 'Wiener Neustadt', 'wiener_neustadt', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(19, 'Bischofshofen', 'bischofshofen', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(20, 'Villach', 'villach', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(21, 'Linz', 'linz', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(22, 'Krems', 'krems', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(23, 'Wiedeń', 'wieden', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(24, 'Gmund', 'gmund', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(25, 'Klagenfurt', 'klagenfurt', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(26, 'Wels', 'wels', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(27, 'Innsbruck', 'innsbruck', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(28, 'Salzburg', 'salzburg', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(29, 'Judenburg', 'judenburg', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(30, 'Kitzbuhel', 'kitzbuhel', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(31, 'Graz', 'graz', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(32, 'Eisenerz', 'eisenerz', 2);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(33, 'Bosanski Brod', 'bosanski_brod', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(34, 'Zenica', 'zenica', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(35, 'Tuluza', 'tuluza', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(36, 'Brhac', 'brhac', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(37, 'Mostar', 'mostar', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(38, 'Konjic', 'konjic', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(39, 'Vareś', 'vares', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(40, 'Sarajewo', 'sarajewo', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(41, 'Banja luka', 'banja_luka', 3);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(42, 'Delchevo', 'delchevo', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(43, 'Mogila', 'mogila', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(44, 'Tetovo', 'tetovo', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(45, 'Resen', 'resen', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(46, 'Bitola', 'bitola', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(47, 'Studenichani', 'studenichani', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(48, 'Zhelino', 'zhelino', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(49, 'Demir', 'demir', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(50, 'Kochani', 'kochani', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(51, 'Berovo', 'berovo', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(52, 'Shtip', 'shtip', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(53, 'Kumanovo', 'kumanovo', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(54, 'Vinitsa', 'vinitsa', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(55, 'Debar', 'debar', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(56, 'Skopje', 'skopje', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(57, 'Gostivar', 'gostivar', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(58, 'Gevgelija', 'gevgelija', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(59, 'Sveti Nikole', 'sveti_nikole', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(60, 'Strumitsa', 'strumitsa', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(61, 'Probishtip', 'probishtip', 4);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(62, 'Karaganda', 'karaganda', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(63, 'Uralsk', 'uralsk', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(64, 'Ekibastuz', 'ekibastuz', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(65, 'Semipalatinsk', 'semipalatinsk', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(66, 'Balkhash', 'balkhash', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(67, 'Ust-kamenogorsk', 'ust_kamenogorsk', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(68, 'Rudnyy', 'rudnyy', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(69, 'Astana', 'astana', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(70, 'Almaty', 'almaty', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(71, 'Kustanay', 'kustanay', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(72, 'Pavlodar', 'pavlodar', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(73, 'Atyrau', 'atyrau', 5);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(74, 'Notodden', 'notodden', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(75, 'Alesund', 'alesund', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(76, 'Kristiansund', 'kristiansund', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(77, 'Sarbsborg', 'sarbsborg', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(78, 'Drammen', 'drammen', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(79, 'Oslo', 'oslo', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(80, 'Steinkjer', 'steinkjer', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(81, 'Trondheim', 'trondheim', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(82, 'Stavanger', 'stavanger', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(83, 'Bergen', 'bergen', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(84, 'Alta', 'alta', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(85, 'Narwik', 'narwik', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(86, 'Bodo', 'bodo', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(87, 'Mo i Tana', 'mo_i_tana', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(88, 'Haugesund', 'haugesund', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(89, 'Kamar', 'kamar', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(90, 'Namosos', 'namosos', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(91, 'Gjovik', 'gjovik', 6);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(92, 'Lwów', 'lwow', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(93, 'Za', 'za', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(94, 'Mikołajów', 'mikolajow', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(95, 'Odessa', 'odessa', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(96, 'Kijów', 'kijow', 7);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(97, 'San Marino', 'san_marino', 8);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(98, 'Port Sudan', 'port_sudan', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(99, 'Al-Faszir', 'al_faszir', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(100, 'Wadi Halfa', 'wadi_halfa', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(101, 'Dżuba', 'dzuba', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(102, 'Chartum', 'chartum', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(103, 'Omdurman', 'omdurman', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(104, 'Wau', 'wau', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(105, 'Al-Ubajid', 'al_ubajid', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(106, 'Nyala', 'nyala', 9);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(107, 'Vancouver', 'vancouver', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(108, 'Toronto', 'toronto', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(109, 'Montreal', 'montreal', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(110, 'Yellownife', 'yellownife', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(111, 'Edmonton', 'edmonton', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(112, 'Halifax', 'halifax', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(113, 'Whitehorse', 'whitehorse', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(114, 'Quebec', 'quebec', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(115, 'Ottawa', 'ottawa', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(116, 'Tredericton', 'tredericton', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(117, 'Calgary', 'calgary', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(118, 'St. Jon''s', 'st_jon_s', 10);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(119, 'Dublin', 'dublin', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(120, 'Waterford', 'waterford', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(121, 'Atholne', 'atholne', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(122, 'Mullingar', 'mullingar', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(123, 'Cork', 'cork', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(124, 'Limerick', 'limerick', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(125, 'Clonmel', 'clonmel', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(126, 'Wexford', 'wexford', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(127, 'Galway', 'galway', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(128, 'Arklow', 'arklow', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(129, 'Ballinrobe', 'ballinrobe', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(130, 'New Ross', 'new_ross', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(131, 'Drogheda', 'drogheda', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(132, 'Tullamore', 'tullamore', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(133, 'Swords', 'swords', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(134, 'Tuam', 'tuam', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(135, 'Kikenny', 'kikenny', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(136, 'Wicklow', 'wicklow', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(137, 'Claremorris', 'claremorris', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(138, 'Castlebar', 'castlebar', 11);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(139, 'Andora', 'andora', 12);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(140, 'Multan', 'multan', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(141, 'Karachi', 'karachi', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(142, 'Hyderabad', 'hyderabad', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(143, 'Islambad', 'islambad', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(144, 'Hoshab', 'hoshab', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(145, 'Okara', 'okara', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(146, 'Quetta', 'quetta', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(147, 'Jhang', 'jhang', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(148, 'Nultal', 'nultal', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(149, 'Lahore', 'lahore', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(150, 'Panigur', 'panigur', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(151, 'Skkur', 'skkur', 13);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(152, 'Veszprem', 'veszprem', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(153, 'Budapeszt', 'budapeszt', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(154, 'Szombathely', 'szombathely', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(155, 'Miszkolc', 'miszkolc', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(156, 'Salgotarjan', 'salgotarjan', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(157, 'Nagykanizsa', 'nagykanizsa', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(158, 'Hodmezovasarnely', 'hodmezovasarnely', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(159, 'Eger', 'eger', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(160, 'Pecz', 'pecz', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(161, 'Szazhalombatta', 'szazhalombatta', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(162, 'Szolnok', 'szolnok', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(163, 'Zalaegerszeg', 'zalaegerszeg', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(164, 'Cegled', 'cegled', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(165, 'Baja', 'baja', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(166, 'Debreczyn', 'debreczyn', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(167, 'Segedyn', 'segedyn', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(168, 'Tatabanya', 'tatabanya', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(169, 'Nyiregyhaza', 'nyiregyhaza', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(170, 'Tokaj', 'tokaj', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(171, 'Dunaujvaros', 'dunaujvaros', 14);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(172, 'Atlanta', 'atlanta', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(173, 'Cleveland', 'cleveland', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(174, 'Baltimore', 'baltimore', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(175, 'Chicago', 'chicago', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(176, 'Columbus', 'columbus', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(177, 'San Francisco', 'san_francisco', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(178, 'Boston', 'boston', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(179, 'Waszyngton', 'waszyngton', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(180, 'Nowy Jork', 'nowy_jork', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(181, 'Tampa', 'tampa', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(182, 'Los Angeles', 'los_angeles', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(183, 'Miami', 'miami', 15);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(184, 'Celije', 'celije', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(185, 'Gorycja', 'gorycja', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(186, 'Postojna', 'postojna', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(187, 'Lubana', 'lubana', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(188, 'Kranj', 'kranj', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(189, 'Maribor', 'maribor', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(190, 'Titoco', 'titoco', 16);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(191, 'Kduna', 'kduna', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(192, 'Benin City', 'benin_city', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(193, 'Abudża', 'abudza', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(194, 'Ibadan', 'ibadan', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(195, 'Ollorin', 'ollorin', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(196, 'Calabar', 'calabar', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(197, 'Maktuguri', 'maktuguri', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(198, 'Port Harcourt', 'port_harcourt', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(199, 'Kano', 'kano', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(200, 'Zaria', 'zaria', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(201, 'Lagos', 'lagos', 17);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(202, 'Ufa', 'ufa', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(203, 'Togliatti', 'togliatti', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(204, 'Krasnodar', 'krasnodar', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(205, 'Penza', 'penza', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(206, 'Perm', 'perm', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(207, 'Jekaterynburg', 'jekaterynburg', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(208, 'Saratów', 'saratow', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(209, 'Tuła', 'tula', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(210, 'Wołgograd', 'wolgograd', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(211, 'Lżewsk', 'lzewsk', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(212, 'Jarosław', 'jaroslaw', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(213, 'Czelabińssk', 'czelabinssk', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(214, 'Samara', 'samara', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(215, 'Moskwa', 'moskwa', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(216, 'Orenburg', 'orenburg', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(217, 'Perersburg', 'perersburg', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(218, 'Rostów nad Donem', 'rostow_nad_donem', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(219, 'Uljanowsk', 'uljanowsk', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(220, 'Kazań', 'kazan', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(221, 'Woroneż', 'woronez', 18);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(222, 'Bukareszt', 'bukareszt', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(223, 'Suceava', 'suceava', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(224, 'Ruse', 'ruse', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(225, 'Craiova', 'craiova', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(226, 'Timisoara', 'timisoara', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(227, 'Oradea', 'oradea', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(228, 'Ploiesti', 'ploiesti', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(229, 'Sibiu', 'sibiu', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(230, 'Tesita', 'tesita', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(231, 'Galati', 'galati', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(232, 'Iasi', 'iasi', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(233, 'Brasov', 'brasov', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(234, 'Baia Mare', 'baia_mare', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(235, 'Braila', 'braila', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(236, 'Arad', 'arad', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(237, 'Botosani', 'botosani', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(238, 'Focsani', 'focsani', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(239, 'Constanta', 'constanta', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(240, 'Turnu-severin', 'turnu_severin', 19);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(241, 'Glasgow', 'glasgow', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(242, 'Falkirk', 'falkirk', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(243, 'Hamilton', 'hamilton', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(244, 'Forfar', 'forfar', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(245, 'Stonehaven', 'stonehaven', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(246, 'Stirling', 'stirling', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(247, 'Arboroath', 'arboroath', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(248, 'Livingston', 'livingston', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(249, 'Inverness', 'inverness', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(250, 'Greenock', 'greenock', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(251, 'Peterhead', 'peterhead', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(252, 'Paisley', 'paisley', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(253, 'Alness', 'alness', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(254, 'Ullapool', 'ullapool', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(255, 'Elgin', 'elgin', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(256, 'Dundee', 'dundee', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(257, 'Tain', 'tain', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(258, 'Kilmarnock', 'kilmarnock', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(259, 'Nairn', 'nairn', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(260, 'Edinburgh', 'edinburgh', 20);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(261, 'Zhengzhou', 'zhengzhou', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(262, 'Wenzhou', 'wenzhou', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(263, 'Tianjin', 'tianjin', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(264, 'Shenyang', 'shenyang', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(265, 'Kanton', 'kanton', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(266, 'Wuhan', 'wuhan', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(267, 'Huainan', 'huainan', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(268, 'Chandsha', 'chandsha', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(269, 'Pekin', 'pekin', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(270, 'Harbin', 'harbin', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(271, 'Jilin', 'jilin', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(272, 'Jinan', 'jinan', 21);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(273, 'Nimegen', 'nimegen', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(274, 'Eindhoven', 'eindhoven', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(275, 'Tilburg', 'tilburg', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(276, 'Den Helder', 'den_helder', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(277, 'Vlissingen', 'vlissingen', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(278, 'Zwolle', 'zwolle', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(279, 'Amsterdam', 'amsterdam', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(280, 'Haarlem', 'haarlem', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(281, 'Leeuwarden', 'leeuwarden', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(282, 'Breda', 'breda', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(283, 'Haga', 'haga', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(284, 'Maastricht', 'maastricht', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(285, 'Enschede', 'enschede', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(286, 'Arnhem', 'arnhem', 22);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(287, 'Kair', 'kair', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(288, 'Luxor', 'luxor', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(289, 'Asyut', 'asyut', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(290, 'Alexandia', 'alexandia', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(291, 'Aswan', 'aswan', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(292, 'Kharga Oasis', 'kharga_oasis', 23);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(293, 'Burgos', 'burgos', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(294, 'Albacete', 'albacete', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(295, 'Madryt', 'madryt', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(296, 'Murcja', 'murcja', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(297, 'Palencia', 'palencia', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(298, 'Ecija', 'ecija', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(299, 'Bilbao', 'bilbao', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(300, 'Saragossa', 'saragossa', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(301, 'La Linea', 'la_linea', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(302, 'Santander', 'santander', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(303, 'Cuenca', 'cuenca', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(304, 'Algeciras', 'algeciras', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(305, 'Orihuela', 'orihuela', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(306, 'Walencja', 'walencja', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(307, 'Malaga', 'malaga', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(308, 'Barcelona', 'barcelona', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(309, 'Sewilla', 'sewilla', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(310, 'Tortosa', 'tortosa', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(311, 'Soria', 'soria', 24);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(312, 'Reykjavik', 'reykjavik', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(313, 'Blonduos', 'blonduos', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(314, 'Akureyri', 'akureyri', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(315, 'Grindavik', 'grindavik', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(316, 'Selfoss', 'selfoss', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(317, 'Vik', 'vik', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(318, 'Hafnarfordhur', 'hafnarfordhur', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(319, 'Hvammstangi', 'hvammstangi', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(320, 'Dalvik', 'dalvik', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(321, 'Neskaupstadhur', 'neskaupstadhur', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(322, 'Vogar', 'vogar', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(323, 'Egilsstadhir', 'egilsstadhir', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(324, 'Porklakshofn', 'porklakshofn', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(325, 'Borgarfjorour', 'borgarfjorour', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(326, 'Hella', 'hella', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(327, 'Djupivogur', 'djupivogur', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(328, 'Husavik', 'husavik', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(329, 'Keflavik', 'keflavik', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(330, 'Mosfellsbaer', 'mosfellsbaer', 25);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(331, 'Zadar', 'zadar', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(332, 'Biograd', 'biograd', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(333, 'Karlovac', 'karlovac', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(334, 'Szybenik', 'szybenik', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(335, 'Split', 'split', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(336, 'Vinkovici', 'vinkovici', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(337, 'Varazdin', 'varazdin', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(338, 'Knin', 'knin', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(339, 'Virovitica', 'virovitica', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(340, 'Pula', 'pula', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(341, 'Ploce', 'ploce', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(342, 'Dubrownik', 'dubrownik', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(343, 'Rijeka', 'rijeka', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(344, 'Sisak', 'sisak', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(345, 'Osijek', 'osijek', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(346, 'Opatija', 'opatija', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(347, 'Zagrzeb', 'zagrzeb', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(348, 'Senj', 'senj', 26);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(349, 'Delhi', 'delhi', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(350, 'Patna', 'patna', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(351, 'Rawalpindi', 'rawalpindi', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(352, 'New Delhi', 'new_delhi', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(353, 'Lakhnau', 'lakhnau', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(354, 'Kalkuta', 'kalkuta', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(355, 'Labaur', 'labaur', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(356, 'Faisalabad', 'faisalabad', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(357, 'Kojamputtur', 'kojamputtur', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(358, 'Bombaj', 'bombaj', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(359, 'Maduraj', 'maduraj', 27);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(360, 'Ryshkany', 'ryshkany', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(361, 'Kiszyniów', 'kiszyniow', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(362, 'Ialoveni', 'ialoveni', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(363, 'Leova', 'leova', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(364, 'Nisporeni', 'nisporeni', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(365, 'Criuleni', 'criuleni', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(366, 'Soroca', 'soroca', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(367, 'Ocnita', 'ocnita', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(368, 'Orhei', 'orhei', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(369, 'Komrat', 'komrat', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(370, 'Kagul', 'kagul', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(371, 'Cantemir', 'cantemir', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(372, 'Bessarabka', 'bessarabka', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(373, 'Anenii Noi', 'anenii_noi', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(374, 'Rezina', 'rezina', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(375, 'Tarakliya', 'tarakliya', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(376, 'Chisianau', 'chisianau', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(377, 'Drochia', 'drochia', 28);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(378, 'Karlstad', 'karlstad', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(379, 'Sztokholm', 'sztokholm', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(380, 'Oxelosund', 'oxelosund', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(381, 'Trollhattan', 'trollhattan', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(382, 'Lund', 'lund', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(383, 'Eskilstuna', 'eskilstuna', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(384, 'Falum', 'falum', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(385, 'Orebro', 'orebro', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(386, 'Boden', 'boden', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(387, 'Kalmar', 'kalmar', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(388, 'Boras', 'boras', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(389, 'Linkoping', 'linkoping', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(390, 'Harnosand', 'harnosand', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(391, 'Vasteras', 'vasteras', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(392, 'Goteborg', 'goteborg', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(393, 'Uppsala', 'uppsala', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(394, 'Gavle', 'gavle', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(395, 'Malmo', 'malmo', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(396, 'Trelleborg', 'trelleborg', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(397, 'Norrkoping', 'norrkoping', 29);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(398, 'Mendoza', 'mendoza', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(399, 'Parana', 'parana', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(400, 'Formosa', 'formosa', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(401, 'San Carlos de Bariloche', 'san_carlos_de_bariloche', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(402, 'Tosario', 'tosario', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(403, 'Salta', 'salta', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(404, 'Las Heras', 'las_heras', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(405, 'Santa Fe', 'santa_fe', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(406, 'Deseado', 'deseado', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(407, 'Buenos Aires', 'buenos_aires', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(408, 'Resistencja', 'resistencja', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(409, 'Cordoba', 'cordoba', 30);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(410, 'Baghian', 'baghian', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(411, 'Charikar', 'charikar', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(412, 'Qonduz', 'qonduz', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(413, 'Meymaneh', 'meymaneh', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(414, 'Sheberghan', 'sheberghan', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(415, 'Farah', 'farah', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(416, 'Lashkar Gah', 'lashkar_gah', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(417, 'Kabul', 'kabul', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(418, 'Kandahar', 'kandahar', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(419, 'Mazare Sharif', 'mazare_sharif', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(420, 'Herat', 'herat', 31);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(421, 'Niksic', 'niksic', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(422, 'Podgorica', 'podgorica', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(423, 'Bar', 'bar', 32);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(424, 'San Luis Potosi', 'san_luis_potosi', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(425, 'Monterrey', 'monterrey', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(426, 'Mexicali', 'mexicali', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(427, 'Peubla', 'peubla', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(428, 'Ciudad Juarez', 'ciudad_juarez', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(429, 'Torreon', 'torreon', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(430, 'Tampico', 'tampico', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(431, 'Guadalajara', 'guadalajara', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(432, 'Meksyk', 'meksyk', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(433, 'Merida', 'merida', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(434, 'Tijuana', 'tijuana', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(435, 'Chihuahua', 'chihuahua', 33);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(436, 'Żylina', 'zylina', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(437, 'Spiska', 'spiska', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(438, 'Roznava', 'roznava', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(439, 'Pieszczyny', 'pieszczyny', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(440, 'Komarno', 'komarno', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(441, 'Preszów', 'preszow', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(442, 'Żar', 'zar', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(443, 'Bratysława', 'bratyslawa', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(444, 'Humenne', 'humenne', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(445, 'Koszyce', 'koszyce', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(446, 'Łuczeniec', 'luczeniec', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(447, 'Bańska Bystrzyca', 'banska_bystrzyca', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(448, 'Nitra', 'nitra', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(449, 'Trnava', 'trnava', 34);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(450, 'Lubumbashi', 'lubumbashi', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(451, 'Mbandaka', 'mbandaka', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(452, 'Kindu', 'kindu', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(453, 'Kinszasa', 'kinszasa', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(454, 'Kisangani', 'kisangani', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(455, 'Keleme', 'keleme', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(456, 'Kananga', 'kananga', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(457, 'Mbuji-Mayi', 'mbuji_mayi', 35);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(458, 'Kemi', 'kemi', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(459, 'Kuopio', 'kuopio', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(460, 'Vaasa', 'vaasa', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(461, 'Turku', 'turku', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(462, 'Espoo', 'espoo', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(463, 'Wyborg', 'wyborg', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(464, 'Kotka', 'kotka', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(465, 'Helsinki', 'helsinki', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(466, 'Pori', 'pori', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(467, 'Lahti', 'lahti', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(468, 'Tampere', 'tampere', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(469, 'Oulu', 'oulu', 36);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(470, 'OlitaKowno', 'olitakowno', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(471, 'Kiejdany', 'kiejdany', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(472, 'Kłajpeda', 'klajpeda', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(473, 'Janów', 'janow', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(474, 'Poniewież', 'poniewiez', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(475, 'Szawle', 'szawle', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(476, 'Wilno', 'wilno', 37);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(477, 'Mozyrz', 'mozyrz', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(478, 'Nowopłock', 'nowoplock', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(479, 'Brześć', 'brzesc', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(480, 'Homel', 'homel', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(481, 'Bobrujsk', 'bobrujsk', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(482, 'Witebsk', 'witebsk', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(483, 'Pińsk', 'pinsk', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(484, 'Orsza', 'orsza', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(485, 'Mińsk', 'minsk', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(486, 'Mohylew', 'mohylew', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(487, 'Baranowicze', 'baranowicze', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(488, 'Grodno', 'grodno', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(489, 'Borysów', 'borysow', 38);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(490, 'Sabac', 'sabac', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(491, 'Prizren', 'prizren', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(492, 'Bor', 'bor', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(493, 'Kikinda', 'kikinda', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(494, 'Pancevo', 'pancevo', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(495, 'Subotica', 'subotica', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(496, 'Sombor', 'sombor', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(497, 'Nowy Sad', 'nowy_sad', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(498, 'Prisztina', 'prisztina', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(499, 'Zrenjanin', 'zrenjanin', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(500, 'Novi Pazar', 'novi_pazar', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(501, 'Valjevo', 'valjevo', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(502, 'Kragujevac', 'kragujevac', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(503, 'Belgrad', 'belgrad', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(504, 'Vrasac', 'vrasac', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(505, 'Leskovac', 'leskovac', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(506, 'Kosovska Mitrovica', 'kosovska_mitrovica', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(507, 'Pirot', 'pirot', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(508, 'Cacak', 'cacak', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(509, 'Peć', 'pec', 39);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(510, 'Belo Horizonte', 'belo_horizonte', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(511, 'Salvador', 'salvador', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(512, 'Rio Branco', 'rio_branco', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(513, 'Porto Alegre', 'porto_alegre', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(514, 'Kurytyba', 'kurytyba', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(515, 'Fortalaza', 'fortalaza', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(516, 'Brasilia', 'brasilia', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(517, 'Sao Paulo', 'sao_paulo', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(518, 'Belem', 'belem', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(519, 'Rio de Janeiro', 'rio_de_janeiro', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(520, 'Manaus', 'manaus', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(521, 'Goiania', 'goiania', 40);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(522, 'Korcza', 'korcza', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(523, 'Tirana', 'tirana', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(524, 'Fieri', 'fieri', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(525, 'Durres', 'durres', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(526, 'Vlore', 'vlore', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(527, 'Gjirokastra', 'gjirokastra', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(528, 'Szkodra', 'szkodra', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(529, 'Elbasan', 'elbasan', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(530, 'Berat', 'berat', 41);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(531, 'Cheb', 'cheb', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(532, 'Praga', 'praga', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(533, 'Brno', 'brno', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(534, 'Liberec', 'liberec', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(535, 'Igława', 'iglawa', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(536, 'Most', 'most', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(537, 'Pilzno', 'pilzno', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(538, 'Hradec Kralove', 'hradec_kralove', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(539, 'Uście', 'uscie', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(540, 'Kladno', 'kladno', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(541, 'Czeskie', 'czeskie', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(542, 'Teplica', 'teplica', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(543, 'Jablonec', 'jablonec', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(544, 'Karlowe Wary', 'karlowe_wary', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(545, 'Mlada Boleslav', 'mlada_boleslav', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(546, 'Ołomurie', 'olomurie', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(547, 'Tabor', 'tabor', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(548, 'Pardubice', 'pardubice', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(549, 'Znojmo', 'znojmo', 42);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(550, 'Namibe', 'namibe', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(551, 'Benguela', 'benguela', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(552, 'Huambo', 'huambo', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(553, 'Malange', 'malange', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(554, 'Lobito', 'lobito', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(555, 'Lubango', 'lubango', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(556, 'Luanda', 'luanda', 43);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(557, 'Prato', 'prato', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(558, 'Arezzo', 'arezzo', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(559, 'Mediolan', 'mediolan', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(560, 'Rieti', 'rieti', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(561, 'Turyn', 'turyn', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(562, 'Cosenza', 'cosenza', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(563, 'Genua', 'genua', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(564, 'Rzym', 'rzym', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(565, 'Mesyna', 'mesyna', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(566, 'Isernia', 'isernia', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(567, 'Teramo', 'teramo', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(568, 'Macerata', 'macerata', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(569, 'Palermo', 'palermo', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(570, 'Ankora', 'ankora', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(571, 'Potenza', 'potenza', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(572, 'Siena', 'siena', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(573, 'Bolonia', 'bolonia', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(574, 'L''Aquilla', 'l_aquilla', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(575, 'Neapol', 'neapol', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(576, 'Paola', 'paola', 44);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(577, 'Birdm', 'birdm', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(578, 'Darwin', 'darwin', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(579, 'Brisbane', 'brisbane', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(580, 'Canberra', 'canberra', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(581, 'Perth', 'perth', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(582, 'Sydney', 'sydney', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(583, 'Melbourne', 'melbourne', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(584, 'Hobart', 'hobart', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(585, 'Mount Isa', 'mount_isa', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(586, 'Kalgoorlie', 'kalgoorlie', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(587, 'Adelaide', 'adelaide', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(588, 'Alice Springs', 'alice_springs', 45);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(589, 'Port Elizabeth', 'port_elizabeth', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(590, 'Richards', 'richards', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(591, 'Pretoria', 'pretoria', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(592, 'Johannesburg. Bloemfontein', 'johannesburg_bloemfontein', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(593, 'Kapsztad', 'kapsztad', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(594, 'Durban', 'durban', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(595, 'Newcastle', 'newcastle', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(596, 'East London', 'east_london', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(597, 'Kinberley', 'kinberley', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(598, 'Bay', 'bay', 46);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(599, 'Barreiro', 'barreiro', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(600, 'Porto', 'porto', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(601, 'Viseu', 'viseu', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(602, 'Covilha', 'covilha', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(603, 'Braganca', 'braganca', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(604, 'Castelo Branco', 'castelo_branco', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(605, 'Faro', 'faro', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(606, 'Coimbra', 'coimbra', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(607, 'Sines', 'sines', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(608, 'Setubal', 'setubal', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(609, 'Vila Real', 'vila_real', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(610, 'Beja', 'beja', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(611, 'Braga', 'braga', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(612, 'Evora', 'evora', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(613, 'Lizbona', 'lizbona', 47);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(614, 'Luksemburg', 'luksemburg', 48);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(615, 'Drama', 'drama', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(616, 'Patras', 'patras', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(617, 'Larisa', 'larisa', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(618, 'Edesa', 'edesa', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(619, 'Teby', 'teby', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(620, 'Kawala', 'kawala', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(621, 'Komotini', 'komotini', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(622, 'Kalamata', 'kalamata', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(623, 'Ksanthi', 'ksanthi', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(624, 'Saloniki', 'saloniki', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(625, 'Pireus', 'pireus', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(626, 'Ateny', 'ateny', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(627, 'Kastoria', 'kastoria', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(628, 'Agrinion', 'agrinion', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(629, 'Mykeny', 'mykeny', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(630, 'Janina', 'janina', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(631, 'Arta', 'arta', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(632, 'Thalkis', 'thalkis', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(633, 'Korynt', 'korynt', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(634, 'Aolos', 'aolos', 49);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(635, 'Holyhead', 'holyhead', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(636, 'Porthmadog', 'porthmadog', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(637, 'Nefyn', 'nefyn', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(638, 'Swansea', 'swansea', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(639, 'Welshpool', 'welshpool', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(640, 'Caernarfon', 'caernarfon', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(641, 'Barry', 'barry', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(642, 'Llandwrog', 'llandwrog', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(643, 'Ffestiniog', 'ffestiniog', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(644, 'Valley', 'valley', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(645, 'Cardiff', 'cardiff', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(646, 'Neath', 'neath', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(647, 'Wrexham', 'wrexham', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(648, 'Morriston', 'morriston', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(649, 'Barmouth', 'barmouth', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(650, 'Knighton', 'knighton', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(651, 'Buckley', 'buckley', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(652, 'Newport', 'newport', 50);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(653, 'Windawa', 'windawa', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(654, 'Dyneburg', 'dyneburg', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(655, 'Valmiera', 'valmiera', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(656, 'Olaine', 'olaine', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(657, 'Rzeżyca', 'rzezyca', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(658, 'Lipawa', 'lipawa', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(659, 'Jełgawa', 'jelgawa', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(660, 'Ryga', 'ryga', 51);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(661, 'Batna', 'batna', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(662, 'Ain Temouchent', 'ain_temouchent', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(663, 'Selic', 'selic', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(664, 'Annaba', 'annaba', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(665, 'Sidi Bei Abbes', 'sidi_bei_abbes', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(666, 'Medea', 'medea', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(667, 'Oran', 'oran', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(668, 'Golea', 'golea', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(669, 'Touggourt', 'touggourt', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(670, 'Algier', 'algier', 52);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(671, 'Medellin', 'medellin', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(672, 'Pasto', 'pasto', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(673, 'Armenia', 'armenia', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(674, 'Bogota', 'bogota', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(675, 'Buenacentura', 'buenacentura', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(676, 'Pereira', 'pereira', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(677, 'Cali', 'cali', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(678, 'Neiva', 'neiva', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(679, 'Macizales', 'macizales', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(680, 'Villavinencio', 'villavinencio', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(681, 'Popayan', 'popayan', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(682, 'Tulua', 'tulua', 53);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(683, 'Tartu', 'tartu', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(684, 'Halinga', 'halinga', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(685, 'Vasalemma', 'vasalemma', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(686, 'Audruo', 'audruo', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(687, 'Keila', 'keila', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(688, 'Tallinn', 'tallinn', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(689, 'Sindii', 'sindii', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(690, 'Kehtna', 'kehtna', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(691, 'Kohtla-Jarve', 'kohtla_jarve', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(692, 'Parnwa', 'parnwa', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(693, 'Sindi', 'sindi', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(694, 'Tidala', 'tidala', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(695, 'Kunda', 'kunda', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(696, 'Vinni', 'vinni', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(697, 'Kivioli', 'kivioli', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(698, 'Vijandi', 'vijandi', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(699, 'Narva', 'narva', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(700, 'Taebla', 'taebla', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(701, 'Pamu', 'pamu', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(702, 'Marjamaa', 'marjamaa', 54);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(703, 'Varde', 'varde', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(704, 'Logstor', 'logstor', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(705, 'Koge', 'koge', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(706, 'Slagelse', 'slagelse', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(707, 'Kopenhaga', 'kopenhaga', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(708, 'Haderslev', 'haderslev', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(709, 'Viborg', 'viborg', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(710, 'Kolding', 'kolding', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(711, 'Vodskov', 'vodskov', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(712, 'Herming', 'herming', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(713, 'Fredericia', 'fredericia', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(714, 'Odense', 'odense', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(715, 'Skive', 'skive', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(716, 'Esbjerg', 'esbjerg', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(717, 'Holstebro', 'holstebro', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(718, 'Sonderborg', 'sonderborg', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(719, 'Aalborg', 'aalborg', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(720, 'Nibe', 'nibe', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(721, 'Vejen', 'vejen', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(722, 'Svendborg', 'svendborg', 55);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(723, 'Wrocław', 'wroclaw', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(724, 'Szczecin', 'szczecin', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(725, 'Łódź', 'lodz', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(726, 'Lublin', 'lublin', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(727, 'Katowice', 'katowice', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(728, 'Tarnobrzeg', 'tarnobrzeg', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(729, 'Gdańsk', 'gdansk', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(730, 'Gdynia', 'gdynia', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(731, 'Kraków', 'krakow', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(732, 'Chorzów', 'chorzow', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(733, 'Warszawa', 'warszawa', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(734, 'Rzeszów', 'rzeszow', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(735, 'Elbląg', 'elblag', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(736, 'Zakopane', 'zakopane', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(737, 'Olsztyn', 'olsztyn', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(738, 'Radom', 'radom', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(739, 'Zamość', 'zamosc', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(740, 'Opole', 'opole', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(741, 'Poznań', 'poznan', 56);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(742, 'Locarno', 'locarno', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(743, 'Fryburg', 'fryburg', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(744, 'Thun', 'thun', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(745, 'Winterthur', 'winterthur', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(746, 'Brig', 'brig', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(747, 'Davos', 'davos', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(748, 'Chur', 'chur', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(749, 'St. Mortiz', 'st_mortiz', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(750, 'Zurych', 'zurych', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(751, 'Szafuza', 'szafuza', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(752, 'Lozanna', 'lozanna', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(753, 'Montreux', 'montreux', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(754, 'St. Gallen', 'st_gallen', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(755, 'Interlaken', 'interlaken', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(756, 'Biel', 'biel', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(757, 'Bazylea', 'bazylea', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(758, 'Berno', 'berno', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(759, 'Neuchatel', 'neuchatel', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(760, 'Lugano', 'lugano', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(761, 'Genewa', 'genewa', 57);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(762, 'Caracas', 'caracas', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(763, 'Ciudad Bolivar', 'ciudad_bolivar', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(764, 'Maturin', 'maturin', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(765, 'Barinas', 'barinas', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(766, 'El Limon', 'el_limon', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(767, 'Maracaibo', 'maracaibo', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(768, 'Valencia', 'valencia', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(769, 'Cumana', 'cumana', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(770, 'San Cristobal', 'san_cristobal', 58);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(771, 'Wittenberga', 'wittenberga', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(772, 'Hanower', 'hanower', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(773, 'Ingolstadt', 'ingolstadt', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(774, 'Salzwedel', 'salzwedel', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(775, 'Kempten', 'kempten', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(776, 'Kolonia', 'kolonia', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(777, 'Hamburg', 'hamburg', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(778, 'Uelzen', 'uelzen', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(779, 'Celle', 'celle', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(780, 'Pluda', 'pluda', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(781, 'Dortmund', 'dortmund', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(782, 'Amberg', 'amberg', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(783, 'Stuttgart', 'stuttgart', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(784, 'Frankfurt', 'frankfurt', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(785, 'Eisenach', 'eisenach', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(786, 'Brema', 'brema', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(787, 'Monachium', 'monachium', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(788, 'Paderborn', 'paderborn', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(789, 'Berlin', 'berlin', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(790, 'Bonn', 'bonn', 59);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(791, 'Khamis Mushayt', 'khamis_mushayt', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(792, 'Al Farsh', 'al_farsh', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(793, 'Ar-Rijad', 'ar_rijad', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(794, 'Ank', 'ank', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(795, 'Gabouk', 'gabouk', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(796, 'Brydah', 'brydah', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(797, 'Ar Riyad', 'ar_riyad', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(798, 'Kuba', 'kuba', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(799, 'Jeddah', 'jeddah', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(800, 'Jizan', 'jizan', 60);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(801, 'Charleroi', 'charleroi', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(802, 'Arlon', 'arlon', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(803, 'Antwerpia', 'antwerpia', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(804, 'Brugia', 'brugia', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(805, 'Ostenda', 'ostenda', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(806, 'Gandawa', 'gandawa', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(807, 'Namur', 'namur', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(808, 'Bruksela', 'bruksela', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(809, 'Liege', 'liege', 61);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(810, 'Agen', 'agen', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(811, 'Lyon', 'lyon', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(812, 'chalons sur-Marne', 'chalons_sur_marne', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(813, 'Marsylia', 'marsylia', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(814, 'Vichy', 'vichy', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(815, 'Rochefort', 'rochefort', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(816, 'Bordeaux', 'bordeaux', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(817, 'St-Brieuc', 'st_brieuc', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(818, 'La Rochelle', 'la_rochelle', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(819, 'Hawr', 'hawr', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(820, 'Vierzon', 'vierzon', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(821, 'Poitiers', 'poitiers', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(822, 'Nevers', 'nevers', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(823, 'Montauban', 'montauban', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(824, 'Nantes', 'nantes', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(825, 'Le Mans', 'le_mans', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(826, 'Paryż', 'paryz', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(827, 'Le Creusot', 'le_creusot', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(828, 'Strasburg', 'strasburg', 62);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(829, 'Dobricz', 'dobricz', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(830, 'Wielkie Tyrnowo', 'wielkie_tyrnowo', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(831, 'Szumen', 'szumen', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(832, 'Dimitrowgrad', 'dimitrowgrad', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(833, 'Plewen', 'plewen', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(834, 'Wraca', 'wraca', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(835, 'Łowecz', 'lowecz', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(836, 'Płowdiw', 'plowdiw', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(837, 'Chaskowo', 'chaskowo', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(838, 'Sofia', 'sofia', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(839, 'Kyrdżali', 'kyrdzali', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(840, 'Razgrad', 'razgrad', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(841, 'Montana', 'montana', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(842, 'Stara Zagora', 'stara_zagora', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(843, 'Widin', 'widin', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(844, 'Burgas', 'burgas', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(845, 'Pernik', 'pernik', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(846, 'Łom', 'lom', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(847, 'Blagoewgrad', 'blagoewgrad', 63);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(848, 'Esfahan', 'esfahan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(849, 'Qum', 'qum', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(850, 'Zahedan', 'zahedan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(851, 'Bojnurd', 'bojnurd', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(852, 'Gorgan', 'gorgan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(853, 'Teheran', 'teheran', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(854, 'Sabzevar', 'sabzevar', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(855, 'Neyshabur', 'neyshabur', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(856, 'Karaj', 'karaj', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(857, 'Mashhad', 'mashhad', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(858, 'Shiraz', 'shiraz', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(859, 'Hamadan', 'hamadan', 64);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(860, 'Londyn', 'londyn', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(861, 'Brimingham', 'brimingham', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(862, 'Manchester', 'manchester', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(863, 'Swindon', 'swindon', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(864, 'Darlington', 'darlington', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(865, 'Luton', 'luton', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(866, 'Chelmsford', 'chelmsford', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(867, 'Plymuth', 'plymuth', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(868, 'Leeds', 'leeds', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(869, 'Gloucester', 'gloucester', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(870, 'Hull', 'hull', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(871, 'Liverpool', 'liverpool', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(872, 'Sunderland', 'sunderland', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(873, 'Bristol', 'bristol', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(874, 'Telford', 'telford', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(875, 'Middlesbrouch', 'middlesbrouch', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(876, 'Norwich', 'norwich', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(877, 'Stoke-on-Trent', 'stoke_on_trent', 65);
INSERT INTO `miasto` (`miasto_id`, `nazwa`, `slug`, `panstwo_id`) VALUES(878, 'Grimsby', 'grimsby', 65);

--
-- Zrzut danych tabeli `panstwo`
--

INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(1, 'Peru', 'peru', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(2, 'Austria', 'austria', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(3, 'Bośnia i Hercegownia', 'bosnia_i_hercegownia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(4, 'Macedonia', 'macedonia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(5, 'Kazachstan', 'kazachstan', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(6, 'Norwegia', 'norwegia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(7, 'Ukraina', 'ukraina', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(8, 'San Marino', 'san_marino', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(9, 'Sudan', 'sudan', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(10, 'Kanada', 'kanada', 5);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(11, 'Irlandia', 'irlandia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(12, 'Andora', 'andora', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(13, 'Pakistan', 'pakistan', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(14, 'Węgry', 'wegry', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(15, 'Stany Zjednoczone', 'stany_zjednoczone', 5);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(16, 'Słowenia', 'slowenia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(17, 'Nigieria', 'nigieria', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(18, 'Rosja', 'rosja', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(19, 'Rumunia', 'rumunia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(20, 'Szkocja', 'szkocja', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(21, 'Chiny', 'chiny', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(22, 'Holandia', 'holandia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(23, 'Egipt', 'egipt', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(24, 'Hiszpania', 'hiszpania', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(25, 'Islandia', 'islandia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(26, 'Chorwacja', 'chorwacja', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(27, 'Indie', 'indie', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(28, 'Mołdawia', 'moldawia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(29, 'Szwecja', 'szwecja', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(30, 'Argentyna', 'argentyna', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(31, 'Afganistan', 'afganistan', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(32, 'Czarnogóra', 'czarnogora', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(33, 'Meksyk', 'meksyk', 5);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(34, 'Słowacja', 'slowacja', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(35, 'Demokratyczna Republika Konga', 'demokratyczna_republika_konga', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(36, 'Finlandia', 'finlandia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(37, 'Litwa', 'litwa', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(38, 'Białoruś', 'bialorus', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(39, 'Serbia', 'serbia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(40, 'Brazylia', 'brazylia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(41, 'Albania', 'albania', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(42, 'Czechy', 'czechy', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(43, 'Angola', 'angola', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(44, 'Włochy', 'wlochy', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(45, 'Australia', 'australia', 6);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(46, 'Republika Południowej Afryki', 'republika_poludniowej_afryki', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(47, 'Portugalia', 'portugalia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(48, 'Luksemburg', 'luksemburg', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(49, 'Grecja', 'grecja', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(50, 'Walia', 'walia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(51, 'Łotwa', 'lotwa', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(52, 'Algieria', 'algieria', 4);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(53, 'Kolumbia', 'kolumbia', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(54, 'Estonia', 'estonia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(55, 'Dania', 'dania', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(56, 'Polska', 'polska', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(57, 'Szwajcaria', 'szwajcaria', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(58, 'Wenezuela', 'wenezuela', 1);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(59, 'Niemcy', 'niemcy', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(60, 'Arabia Saudyjska', 'arabia_saudyjska', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(61, 'Belgia', 'belgia', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(62, 'Francja', 'francja', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(63, 'Bułgaria', 'bulgaria', 2);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(64, 'Iran', 'iran', 3);
INSERT INTO `panstwo` (`panstwo_id`, `nazwa`, `slug`, `kontynent_id`) VALUES(65, 'Anglia', 'anglia', 2);

SET FOREIGN_KEY_CHECKS=1;
