set names utf8;
drop database if exists klasyfikacjazwierzat;
create database klasyfikacjazwierzat default character set utf8 collate utf8_polish_ci;
grant all on klasyfikacjazwierzat.* to admin@localhost identified by 'password';
flush privileges;
use klasyfikacjazwierzat;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- gromada
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `gromada`;


CREATE TABLE `gromada`
(
	`gromada_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`gromada` VARCHAR(128),
	`slug` VARCHAR(128),
	PRIMARY KEY (`gromada_id`),
	UNIQUE KEY `gromada_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rzad
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rzad`;


CREATE TABLE `rzad`
(
	`rzad_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rzad` VARCHAR(128),
	`slug` VARCHAR(128),
	`gromada_id` INTEGER,
	PRIMARY KEY (`rzad_id`),
	UNIQUE KEY `rzad_U_1` (`slug`(128)),
	INDEX `FI_rzad_gromada1` (`gromada_id`),
	CONSTRAINT `fk_rzad_gromada1`
		FOREIGN KEY (`gromada_id`)
		REFERENCES `gromada` (`gromada_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rodzina
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rodzina`;


CREATE TABLE `rodzina`
(
	`rodzina_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rodzina` VARCHAR(128),
	`slug` VARCHAR(128),
	`rzad_id` INTEGER,
	PRIMARY KEY (`rodzina_id`),
	INDEX `FI_rodzina_rzad` (`rzad_id`),
	CONSTRAINT `fk_rodzina_rzad`
		FOREIGN KEY (`rzad_id`)
		REFERENCES `rzad` (`rzad_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 10:26
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `klasyfikacjazwierzat`
--

--
-- Zrzut danych tabeli `gromada`
--

INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(1, 'Gady', 'gady');
INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(2, 'Minogi', 'minogi');
INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(3, 'Płazy', 'plazy');
INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(4, 'Ptaki', 'ptaki');
INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(5, 'Ryby chrzęstne', 'ryby_chrzestne');
INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(6, 'Ryby kostne', 'ryby_kostne');
INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(7, 'Śluzice', 'sluzice');
INSERT INTO `gromada` (`gromada_id`, `gromada`, `slug`) VALUES(8, 'Ssaki', 'ssaki');

--
-- Zrzut danych tabeli `rodzina`
--

INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(1, 'Hatteriowate', 'hatteriowate', 1);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(2, 'Gawialowate', 'gawialowate', 2);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(3, 'Aligatorowate', 'aligatorowate', 2);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(4, 'Krokodylowate', 'krokodylowate', 2);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(5, 'Legwanowate', 'legwanowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(6, 'Agamowate', 'agamowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(7, 'Kameleonowate', 'kameleonowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(8, 'Gekonowate', 'gekonowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(9, 'Płatonogowate', 'platonogowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(10, 'Ślepicowate', 'slepicowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(11, 'Tejowate', 'tejowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(12, 'Jaszczurkowate', 'jaszczurkowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(13, 'Nocówkowate', 'nocowkowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(14, 'Scynkowate', 'scynkowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(15, 'Szyszkowcowate', 'szyszkowcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(16, 'Guzowcowate', 'guzowcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(17, 'Padalcowate', 'padalcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(18, 'Pierścieńcowate', 'piersciencowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(19, 'Waranowate', 'waranowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(20, 'Głuchoniowate', 'gluchoniowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(21, 'Helodermowate', 'helodermowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(22, 'Obrączkowcowate', 'obraczkowcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(23, 'Ajolotowate', 'ajolotowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(24, 'Szpicogonowate', 'szpicogonowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(25, 'Nitkowcowate', 'nitkowcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(26, 'Ślepuchowate', 'slepuchowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(27, 'Ociemkowate', 'ociemkowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(28, 'Cylindrowcowate', 'cylindrowcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(29, 'Tarczogonowate', 'tarczogonowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(30, 'Tęczowcowate', 'teczowcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(31, 'Dusicielowate', 'dusicielowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(32, 'Brodawkowcowate', 'brodawkowcowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(33, 'Żmijowate', 'zmijowate', 3);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(34, 'Żółwie błotne', 'zolwie_blotne', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(35, 'Żółwie lądowe', 'zolwie_ladowe', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(36, 'Żółwiakowate', 'zolwiakowate', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(37, 'Miękkosórkowate', 'miekkosorkowate', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(38, 'Spłaszczkowate', 'splaszczkowate', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(39, 'Mułowcowate', 'mulowcowate', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(40, 'Żółwie skórzaste', 'zolwie_skorzaste', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(41, 'Żółwie morskie', 'zolwie_morskie', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(42, 'Skorpuchowate', 'skorpuchowate', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(43, 'Pelomeduzowate', 'pelomeduzowate', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(44, 'Żółwie wężoszyjne', 'zolwie_wezoszyjne', 4);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(45, 'Minotowate', 'minotowate', 5);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(46, 'Łusecznikowate', 'lusecznikowate', 6);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(47, 'Krótkogłowcowate', 'krotkoglowcowate', 6);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(48, 'Marszczelcowate', 'marszczelcowate', 6);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(49, 'Strumienicowate', 'strumienicowate', 6);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(50, 'Ogończakowate', 'ogonczakowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(51, 'Liopelmowate', 'liopelmowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(52, 'Ropuszkowate', 'ropuszkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(53, 'Grzbietorodowate', 'grzbietorodowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(54, 'Nosatkowate', 'nosatkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(55, 'Nurzańcowate', 'nurzancowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(56, 'Grzebiuszkowate', 'grzebiuszkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(57, 'Szklenicowate', 'szklenicowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(58, 'Straszakowate', 'straszakowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(59, 'Ropucowate', 'ropucowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(60, 'Siodlaczkowate', 'siodlaczkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(61, 'Rzekotkowate', 'rzekotkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(62, 'Gardłorodowate', 'gardlorodowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(63, 'Świstkowate', 'swistkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(64, 'Żółwinkowate', 'zolwinkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(65, 'Seszelkowate', 'seszelkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(66, 'Drzewołazowate', 'drzewolazowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(67, 'Sitówkowate', 'sitowkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(68, 'Wąskopyskowate', 'waskopyskowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(69, 'Żabowate', 'zabowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(70, 'Nogolotkowate', 'nogolotkowate', 7);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(71, 'Syrenowate', 'syrenowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(72, 'Amfiumowate', 'amfiumowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(73, 'Odmieńcowate', 'odmiencowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(74, 'Bezpłucnikowate', 'bezplucnikowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(75, 'Ambystomowate', 'ambystomowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(76, 'Skrzeczkowate', 'skrzeczkowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(77, 'Salamandrowate', 'salamandrowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(78, 'Skrytoskrzelowate', 'skrytoskrzelowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(79, 'Kątozębowate', 'katozebowate', 8);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(80, 'Skrzydłoszpony', 'skrzydloszpony', 9);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(81, 'Bezpłetwce', 'bezpletwce', 9);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(82, 'Drzewice', 'drzewice', 9);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(83, 'Kaczkowate', 'kaczkowate', 9);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(84, 'Stepówki', 'stepowki', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(85, 'Andówki', 'andowki', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(86, 'Dropniki', 'dropniki', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(87, 'Złotosłonki', 'zlotoslonki', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(88, 'Długoszpony', 'dlugoszpony', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(89, 'Bekasowate', 'bekasowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(90, 'Pochwodzioby', 'pochwodzioby', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(91, 'Kulony', 'kulony', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(92, 'Żwirowcowate', 'zwirowcowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(93, 'Siewkowate', 'siewkowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(94, 'Mewowate', 'mewowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(95, 'Jastrzębiowate', 'jastrzebiowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(96, 'Sekretarze', 'sekretarze', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(97, 'Sokołowate', 'sokolowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(98, 'Perkozy', 'perkozy', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(99, 'Faetony', 'faetony', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(100, 'Głuptaki', 'gluptaki', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(101, 'Wężówki', 'wezowki', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(102, 'Kormorany', 'kormorany', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(103, 'Czaplowate', 'czaplowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(104, 'Warugi', 'warugi', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(105, 'Flamingi', 'flamingi', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(106, 'Ibisowate', 'ibisowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(107, 'Pelikanowate', 'pelikanowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(108, 'Bocianowate', 'bocianowate', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(109, 'Fregaty', 'fregaty', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(110, 'Pingwiny', 'pingwiny', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(111, 'Nury', 'nury', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(112, 'Rurkonose', 'rurkonose', 10);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(113, 'Czepigi', 'czepigi', 11);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(114, 'Nogale', 'nogale', 12);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(115, 'Czubacze', 'czubacze', 12);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(116, 'Dudki', 'dudki', 13);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(117, 'Sierpodudki', 'sierpodudki', 13);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(118, 'Miodowody', 'miodowody', 14);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(119, 'Dzięcioły', 'dziecioly', 14);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(120, 'Brodacze', 'brodacze', 14);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(121, 'Tukany', 'tukany', 14);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(122, 'Dzioborożce', 'dzioborozce', 15);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(123, 'Dzioborożce naziemne', 'dzioborozce_naziemne', 15);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(124, 'Gołębie', 'golebie', 16);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(125, 'Kurowate', 'kurowate', 17);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(126, 'Perlice', 'perlice', 17);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(127, 'Przepióry', 'przepiory', 17);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(128, 'Jerzyki', 'jerzyki', 18);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(129, 'Czubiki', 'czubiki', 18);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(130, 'Kolibry', 'kolibry', 19);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(131, 'Kraski', 'kraski', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(132, 'Ziemnokraski', 'ziemnokraski', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(133, 'Kurole', 'kurole', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(134, 'Piłodzioby', 'pilodzioby', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(135, 'Płaskodzióbki', 'plaskodziobki', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(136, 'Żołny', 'zolny', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(137, 'Zimorodki właściwe', 'zimorodki_wlasciwe', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(138, 'Kukaburowate', 'kukaburowate', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(139, 'Rybaczki', 'rybaczki', 20);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(140, 'Kukale', 'kukale', 21);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(141, 'Kukawiki', 'kukawiki', 21);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(142, 'Hoacyny', 'hoacyny', 21);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(143, 'Kleszczojady', 'kleszczojady', 21);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(144, 'Kukawkowate', 'kukawkowate', 21);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(145, 'Kusaki', 'kusaki', 22);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(146, 'Papugi', 'papugi', 23);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(147, 'Przepiórniki', 'przepiorniki', 24);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(148, 'Płomykówki', 'plomykowki', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(149, 'Puszczykowate', 'puszczykowate', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(150, 'Zmierzchniki', 'zmierzchniki', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(151, 'Paszczaki australijskie', 'paszczaki_australijskie', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(152, 'Paszczaki azjatyckie', 'paszczaki_azjatyckie', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(153, 'Tłuszczaki', 'tluszczaki', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(154, 'Nocoloty', 'nocoloty', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(155, 'Eurostopodidae', 'eurostopodidae', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(156, 'Lelki', 'lelki', 25);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(157, 'Strusie', 'strusie', 26);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(158, 'Nandu', 'nandu', 26);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(159, 'Kazuarowate', 'kazuarowate', 26);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(160, 'Kiwi', 'kiwi', 26);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(161, 'Trogony', 'trogony', 27);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(162, 'Turaki', 'turaki', 28);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(163, 'Bargliki', 'bargliki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(164, 'Kurtaczki', 'kurtaczki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(165, 'Szerokodzioby', 'szerokodzioby', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(166, 'Drodawniki', 'drodawniki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(167, 'Tyranki', 'tyranki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(168, 'Mrówkowody', 'mrowkowody', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(169, 'Mrówkowody naziemne', 'mrowkowody_naziemne', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(170, 'Mrówkożery', 'mrowkozery', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(171, 'Tapakole', 'tapakole', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(172, 'Korołazy', 'korolazy', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(173, 'Lirogony', 'lirogony', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(174, 'Altanniki', 'altanniki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(175, 'Chwostki', 'chwostki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(176, 'Miodojady', 'miodojady', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(177, 'Lamparciki', 'lamparciki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(178, 'Gwizdacze', 'gwizdacze', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(179, 'Turkuśniki', 'turkusniki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(180, 'Dzzierzby', 'dzzierzby', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(181, 'Wieronki', 'wieronki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(182, 'Krukowate', 'krukowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(183, 'Koralniki', 'koralniki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(184, 'Sępowronki', 'sepowronki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(185, 'Jemiołuszki', 'jemioluszki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(186, 'Pluszcze', 'pluszcze', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(187, 'Muchołówkowate', 'mucholowkowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(188, 'Szpakowate', 'szpakowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(189, 'Kowalikowate', 'kowalikowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(190, 'Pełzaczowate', 'pelzaczowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(191, 'Sikory', 'sikory', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(192, 'Raniuszki', 'raniuszki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(193, 'Jaskółki', 'jaskolki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(194, 'Bilbile', 'bilbile', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(195, 'Mysikróliki', 'mysikroliki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(196, 'Persówki', 'persowki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(197, 'Chwastówki', 'chwastowki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(198, 'Szlarniki', 'szlarniki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(199, 'Pokrzewkowate', 'pokrzewkowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(200, 'Skowronki', 'skowronki', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(201, 'Nektarnikowate', 'nektarnikowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(202, 'Melanocharitidae', 'melanocharitidae', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(203, 'Wróblowate', 'wroblowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(204, 'Łuszczakowate', 'luszczakowate', 29);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(205, 'Złotki', 'zlotki', 30);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(206, 'Drzymy', 'drzymy', 30);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(207, 'Słonecznice', 'slonecznice', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(208, 'Drpie', 'drpie', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(209, 'Żurawie', 'zurawie', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(210, 'Gruchacze', 'gruchacze', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(211, 'Perkołyski', 'perkolyski', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(212, 'Kariamy', 'kariamy', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(213, 'Kagu', 'kagu', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(214, 'Madagaskarniki', 'madagaskarniki', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(215, 'Chruściele', 'chrusciele', 31);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(216, 'Chimerowate', 'chimerowate', 32);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(217, 'Hakonosowate', 'hakonosowate', 32);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(218, 'Drakonosowate', 'drakonosowate', 32);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(219, 'Drętwowate', 'dretwowate', 33);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(220, 'Koleniowate', 'koleniowate', 34);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(221, 'Rekiny kolczaste', 'rekiny_kolczaste', 34);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(222, 'Liksowate', 'liksowate', 34);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(223, 'Łobegongowate', 'lobegongowate', 35);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(224, 'Rhincodontidae', 'rhincodontidae', 35);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(225, 'Piłonosowate', 'pilonosowate', 36);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(226, 'Piłowate', 'pilowate', 37);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(227, 'Tochowate', 'tochowate', 37);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(228, 'Tajowate', 'tajowate', 37);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(229, 'Ogończowate', 'ogonczowate', 37);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(230, 'Orleniowate', 'orleniowate', 37);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(231, 'Mantowate', 'mantowate', 37);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(232, 'Raszplowate', 'raszplowate', 38);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(233, 'Długoszparowate', 'dlugoszparowate', 39);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(234, 'Tawroszowate', 'tawroszowate', 39);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(235, 'Kosogonowate', 'kosogonowate', 39);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(236, 'Lamnowate', 'lamnowate', 39);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(237, 'Rogatkowate', 'rogatkowate', 40);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(238, 'Żarłaczowate', 'zarlaczowate', 41);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(239, 'Młotowate', 'mlotowate', 41);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(240, 'Rekinowate', 'rekinowate', 41);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(241, 'Albulowate', 'albulowate', 42);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(242, 'Belotkowate', 'belotkowate', 42);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(243, 'Łuskaczowate', 'luskaczowate', 42);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(244, 'Amiowate', 'amiowate', 43);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(245, 'Arowanowate', 'arowanowate', 44);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(246, 'Księżycookowate', 'ksiezycookowate', 44);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(247, 'Brzeszczotkowate', 'brzeszczotkowate', 44);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(248, 'Motylowcowate', 'motylowcowate', 44);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(249, 'Mrukowate', 'mrukowate', 44);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(250, 'Aterynowate', 'aterynowate', 45);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(251, 'Phallostethidae', 'phallostethidae', 45);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(252, 'Tęcznkowate', 'tecznkowate', 45);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(253, 'Jaszczurnikowate', 'jaszczurnikowate', 46);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(254, 'Garpadonowate', 'garpadonowate', 46);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(255, 'Skwatanowate', 'skwatanowate', 46);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(256, 'Przyglądaczowate', 'przygladaczowate', 46);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(257, 'Bathypteroidae', 'bathypteroidae', 46);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(258, 'Żabnicowate', 'zabnicowate', 47);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(259, 'Antenicowate', 'antenicowate', 47);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(260, 'Maźnicowate', 'maznicowate', 47);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(261, 'Maszkarowate', 'maszkarowate', 47);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(262, 'Linofrynowate', 'linofrynowate', 47);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(263, 'Ptaszorowate', 'ptaszorowate', 48);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(264, 'Półdziobcowate', 'poldziobcowate', 48);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(265, 'Belonowate', 'belonowate', 48);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(266, 'Makreloszowate', 'makreloszowate', 48);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(267, 'Kaczorkowate', 'kaczorkowate', 48);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(268, 'Szysznikowate', 'szysznikowate', 49);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(269, 'Hajdukowate', 'hajdukowate', 49);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(270, 'Latarenkowcowate', 'latarenkowcowate', 49);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(271, 'Gardłoszowate', 'gardloszowate', 49);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(272, 'Wąsatkowate', 'wasatkowate', 49);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(273, 'Beryksowate', 'beryksowate', 49);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(274, 'Ciernikowate', 'ciernikowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(275, 'Długopyskowate', 'dlugopyskowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(276, 'Pegazowate', 'pegazowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(277, 'Brzytewnikowate', 'brzytewnikowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(278, 'Igliczniowate', 'igliczniowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(279, 'Rurecznicowate', 'rurecznicowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(280, 'Fistulkowate', 'fistulkowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(281, 'Bekaśnikowate', 'bekasnikowate', 50);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(282, 'Dorszowate', 'dorszowate', 51);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(283, 'Morszczukowate', 'morszczukowate', 51);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(284, 'Buławikowate', 'bulawikowate', 51);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(285, 'Nitkodziobbkowate', 'nitkodziobbkowate', 52);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(286, 'Gardzielcowate', 'gardzielcowate', 52);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(287, 'Jednoszczękowcowate', 'jednoszczekowcowate', 52);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(288, 'Połykaczowate', 'polykaczowate', 52);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(289, 'Jesiotrowate', 'jesiotrowate', 53);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(290, 'Wiosłonosowate', 'wioslonosowate', 53);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(291, 'Strumieniakowate', 'strumieniakowate', 54);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(292, 'Szczupieńczykowate', 'szczupienczykowate', 54);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(293, 'Karpieńcowate', 'karpiencowate', 54);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(294, 'Czworookowate', 'czworookowate', 54);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(295, 'Piękniczkowate', 'piekniczkowate', 54);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(296, 'Karpiowate', 'karpiowate', 55);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(297, 'Czukuczanowate', 'czukuczanowate', 55);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(298, 'Kozowate', 'kozowate', 55);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(299, 'Okrągłoprzyssawkowate', 'okragloprzyssawkowate', 55);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(300, 'Przylgowate', 'przylgowate', 55);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(301, 'Psilorhynchidae', 'psilorhynchidae', 55);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(302, 'Gastromyzontidae', 'gastromyzontidae', 55);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(303, 'Stojaczkowate', 'stojaczkowate', 56);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(304, 'Piraniowate', 'piraniowate', 56);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(305, 'Szczupieńcowate', 'szczupiencowate', 56);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(306, 'Kąsaczowate', 'kasaczowate', 56);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(307, 'Alestesowate', 'alestesowate', 56);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(308, 'Łososiowate', 'lososiowate', 57);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(309, 'Rogatnicowate', 'rogatnicowate', 58);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(310, 'Jednorożkowate', 'jednorozkowate', 58);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(311, 'Kosterowate', 'kosterowate', 58);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(312, 'Kolcobrzuchowate', 'kolcobrzuchowate', 58);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(313, 'Najeżkowate', 'najezkowate', 58);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(314, 'Samogłowowate', 'samoglowowate', 58);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(315, 'Niszczukowate', 'niszczukowate', 59);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(316, 'Skalnikowate', 'skalnikowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(317, 'Okonie południowe', 'okonie_poludniowe', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(318, 'Strzępielowate', 'strzepielowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(319, 'Bassowate', 'bassowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(320, 'Apogonowate', 'apogonowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(321, 'Okoniowate', 'okoniowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(322, 'Tasergalowate', 'tasergalowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(323, 'Kobiowate', 'kobiowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(324, 'Podnawkowate', 'podnawkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(325, 'Ostrobobkowate', 'ostrobobkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(326, 'Smaglowate', 'smaglowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(327, 'Bramowate', 'bramowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(328, 'Lucjanowate', 'lucjanowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(329, 'Trójchwaścikowate', 'trojchwascikowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(330, 'Łuszczowate', 'luszczowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(331, 'Letrowate', 'letrowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(332, 'Prażmowate', 'prazmowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(333, 'Kulbinowate', 'kulbinowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(334, 'Barwenowatem Strzelczykowate', 'barwenowatem_strzelczykowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(335, 'Skubaczowate', 'skubaczowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(336, 'Szczeciozębowate', 'szczeciozebowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(337, 'Ustniczkowate', 'ustniczkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(338, 'Wielocierniowate', 'wielocierniowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(339, 'Aripisowate', 'aripisowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(340, 'Teraponowate', 'teraponowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(341, 'Szumieniowate', 'szumieniowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(342, 'Pielęgnicowate', 'pielegnicowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(343, 'Garbikowate', 'garbikowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(344, 'Wargaczowate', 'wargaczowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(345, 'Skarusowate', 'skarusowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(346, 'Odacidae', 'odacidae', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(347, 'Węgorzycowate', 'wegorzycowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(348, 'Stychejkowate', 'stychejkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(349, 'Krzywopyskowate', 'krzywopyskowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(350, 'Ostropłetwcowate', 'ostropletwcowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(351, 'Zębaczowate', 'zebaczowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(352, 'Nototeniowate', 'nototeniowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(353, 'Bielankowate', 'bielankowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(354, 'Dobijakowate', 'dobijakowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(355, 'Ostroszowate', 'ostroszowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(356, 'Skaberowate', 'skaberowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(357, 'Klinkowate', 'klinkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(358, 'Ślizgowate', 'slizgowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(359, 'Grotnikowate', 'grotnikowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(360, 'Lirowate', 'lirowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(361, 'Draconettidae', 'draconettidae', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(362, 'Śpioszkowate', 'spioszkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(363, 'Poskoczkowate', 'poskoczkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(364, 'Babkowate', 'babkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(365, 'Szpadelkowate', 'szpadelkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(366, 'Argusowate', 'argusowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(367, 'Pokolcowate', 'pokolcowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(368, 'Idolkowate', 'idolkowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(369, 'Cierniopłetwowcowatee', 'cierniopletwowcowatee', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(370, 'Cefalowate', 'cefalowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(371, 'Barakudowate', 'barakudowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(372, 'Pałaszowate', 'palaszowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(373, 'Makrelowate', 'makrelowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(374, 'Żaglicowate', 'zaglicowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(375, 'Miecznikowate', 'miecznikowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(376, 'Nomeuszowate', 'nomeuszowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(377, 'Ąuwakowate', 'auwakowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(378, 'Pompilowate', 'pompilowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(379, 'Tetragonuridae', 'tetragonuridae', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(380, 'Łaźcowate', 'lazcowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(381, 'Beloncjowate', 'beloncjowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(382, 'Guramiowate', 'guramiowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(383, 'Całuskowate', 'caluskowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(384, 'Żmijogłowowate', 'zmijoglowowate', 60);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(385, 'Okoniopstrągowate', 'okoniopstragowate', 61);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(386, 'Okoniopiratowate', 'okoniopiratowate', 61);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(387, 'Ślepe ryby jaskiniowe', 'slepe_ryby_jaskiniowe', 61);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(388, 'Piaskolcowate', 'piaskolcowate', 62);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(389, 'Chanosowate', 'chanosowate', 62);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(390, 'Kneriidae', 'kneriidae', 62);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(391, 'Piotroszowate', 'piotroszowate', 63);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(392, 'Kaproszowate', 'kaproszowate', 63);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(393, 'Jęzorowate', 'jezorowate', 64);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(394, 'Nagładowate', 'nagladowate', 64);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(395, 'Skarpowate', 'skarpowate', 64);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(396, 'Letnicowate', 'letnicowate', 64);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(397, 'Flądrowate', 'fladrowate', 64);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(398, 'Solowate', 'solowate', 64);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(399, 'Ciosankowate', 'ciosankowate', 64);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(400, 'Skorpenowate', 'skorpenowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(401, 'Szkaradnicowate', 'szkaradnicowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(402, 'Kurkowate', 'kurkowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(403, 'Anoplopomowate', 'anoplopomowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(404, 'Terpugowate', 'terpugowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(405, 'Głowaczowate', 'glowaczowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(406, 'Gołomiankowate', 'golomiankowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(407, 'Lisicowate', 'lisicowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(408, 'Dennikowate', 'dennikowate', 65);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(409, 'Kolcobródkowate', 'kolcobrodkowate', 66);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(410, 'Śledziowate', 'sledziowate', 66);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(411, 'Dorabowate', 'dorabowate', 66);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(412, 'Satdelowate', 'satdelowate', 66);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(413, 'Wielorybinkowate', 'wielorybinkowate', 67);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(414, 'Stephanoberycidae', 'stephanoberycidae', 67);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(415, 'Gibberichthyidae', 'gibberichthyidae', 67);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(416, 'Strojnikowate', 'strojnikowate', 68);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(417, 'Regalecidae', 'regalecidae', 68);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(418, 'Wstęgorogowate', 'wstegorogowate', 68);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(419, 'Ateleopidae', 'ateleopidae', 68);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(420, 'Stwolotkowate', 'stwolotkowate', 69);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(421, 'Strętwowate', 'stretwowate', 70);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(422, 'Gymnotowate', 'gymnotowate', 70);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(423, 'Stynkowate', 'stynkowate', 71);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(424, 'Galaksowate', 'galaksowate', 71);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(425, 'Sumikowate', 'sumikowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(426, 'Bagrowate', 'bagrowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(427, 'Sumowate', 'sumowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(428, 'Sumy wędrowne', 'sumy_wedrowne', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(429, 'Długowąsowate', 'dlugowasowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(430, 'Sumy elektryczne', 'sumy_elektryczne', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(431, 'Ariusowate', 'ariusowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(432, 'Mochokidae', 'mochokidae', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(433, 'Kirysowate', 'kirysowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(434, 'Sumiki koralowe', 'sumiki_koralowe', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(435, 'Mandiowate', 'mandiowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(436, 'Zbrojnikowate', 'zbrojnikowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(437, 'Kiryskowate', 'kiryskowate', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(438, 'Sumiki pasożytnicze', 'sumiki_pasozytnicze', 72);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(439, 'Świetlikowate', 'swietlikowate', 73);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(440, 'Szczupakowate', 'szczupakowate', 74);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(441, 'Muławkowate', 'mulawkowate', 74);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(442, 'Tarponowate', 'tarponowate', 75);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(443, 'Elopsowate', 'elopsowate', 75);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(444, 'Węgorze błotne', 'wegorze_blotne', 76);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(445, 'Długonosowate', 'dlugonosowate', 76);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(446, 'Murenowate', 'murenowate', 77);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(447, 'Węgorzowate', 'wegorzowate', 77);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(448, 'Kongerowate', 'kongerowate', 77);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(449, 'Gonostomowate', 'gonostomowate', 78);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(450, 'Przeźreniowate', 'przezreniowate', 78);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(451, 'Wężorowate', 'wezorowate', 78);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(452, 'Źmijowcowate', 'zmijowcowate', 78);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(453, 'Wielopłetwcowate', 'wielopletwcowate', 79);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(454, 'Wyślizgowate', 'wyslizgowate', 80);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(455, 'Brotulowate', 'brotulowate', 80);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(456, 'Brotulowate żyworodne', 'brotulowate_zyworodne', 80);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(457, 'Karapowate', 'karapowate', 80);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(458, 'Śluzicowate', 'sluzicowate', 81);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(459, 'Beztorbikowate', 'beztorbikowate', 82);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(460, 'Psowate', 'psowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(461, 'Niedźwiedziowate', 'niedzwiedziowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(462, 'Szopowate', 'szopowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(463, 'Łasicowate', 'lasicowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(464, 'Łaszowate', 'laszowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(465, 'Mangustowate', 'mangustowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(466, 'Uchatkowate', 'uchatkowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(467, 'Morsowate', 'morsowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(468, 'Fokowate', 'fokowate', 83);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(469, 'Wombatowate', 'wombatowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(470, 'Koalowate', 'koalowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(471, 'Ostronogowate', 'ostronogowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(472, 'Pałankowate', 'palankowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(473, 'Dzewicowate', 'dzewicowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(474, 'Lotopałankowate', 'lotopalankowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(475, 'Pseudocheiridae', 'pseudocheiridae', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(476, 'Kangurowate', 'kangurowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(477, 'Poturuowate', 'poturuowate', 84);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(478, 'Dydelfowate', 'dydelfowate', 85);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(479, 'Góralkowate', 'goralkowate', 86);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(480, 'Wiewiórkowate', 'wiewiorkowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(481, 'Gofferowate', 'gofferowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(482, 'Szczuroskoczkowate', 'szczuroskoczkowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(483, 'Bobrowate', 'bobrowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(484, 'Postrzałkowate', 'postrzalkowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(485, 'Wiewiórolotkowe', 'wiewiorolotkowe', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(486, 'Myszowate', 'myszowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(487, 'Popielicowate', 'popielicowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(488, 'Skoczkowate', 'skoczkowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(489, 'Gundiowate', 'gundiowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(490, 'Jeżozwierzowate', 'jezozwierzowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(491, 'Ursonowate', 'ursonowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(492, 'Marowate', 'marowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(493, 'Kapibarowate', 'kapibarowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(494, 'Pakranowate', 'pakranowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(495, 'Pakowate', 'pakowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(496, 'Agutiowate', 'agutiowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(497, 'Szyszylowate', 'szyszylowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(498, 'Hutiowate', 'hutiowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(499, 'Koszatniczkowate', 'koszatniczkowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(500, 'Tukotukowate', 'tukotukowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(501, 'Szynszyloszczurowate', 'szynszyloszczurowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(502, 'Kolczakowate', 'kolczakowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(503, 'Szczecińcowate', 'szczecincowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(504, 'Skałoszczurowate', 'skaloszczurowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(505, 'Kretoszczurowate', 'kretoszczurowate', 87);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(506, 'Jamrajowate', 'jamrajowate', 88);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(507, 'Krety workowate', 'krety_workowate', 89);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(508, 'Lotokotowate', 'lotokotowate', 90);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(509, 'Pangolinowate', 'pangolinowate', 91);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(510, 'Mrównikowate', 'mrownikowate', 92);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(511, 'Lemurkowate', 'lemurkowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(512, 'Lemurowate', 'lemurowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(513, 'Indrisowate', 'indrisowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(514, 'Paczakowate', 'paczakowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(515, 'Lorisowate', 'lorisowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(516, 'Galagowate', 'galagowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(517, 'Wyrakowate', 'wyrakowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(518, 'Pazurkowcowate', 'pazurkowcowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(519, 'Płaksowate', 'plaksowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(520, 'Koczkodanowate', 'koczkodanowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(521, 'Gibbonowate', 'gibbonowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(522, 'Człowiekowate', 'czlowiekowate', 93);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(523, 'Niełazowate', 'nielazowate', 94);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(524, 'Mrówkożerowate', 'mrowkozerowate', 94);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(525, 'Koniowate', 'koniowate', 95);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(526, 'Tapirowate', 'tapirowate', 95);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(527, 'Nosorożcowate', 'nosorozcowate', 95);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(528, 'Rudawkowate', 'rudawkowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(529, 'Brodawkonosowate', 'brodawkonosowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(530, 'Upiorowate', 'upiorowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(531, 'Świnionosowate', 'swinionosowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(532, 'Bruzdonosowate', 'bruzdonosowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(533, 'Lironosowate', 'lironosowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(534, 'Podkowcowate', 'podkowcowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(535, 'Rybakowate', 'rybakowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(536, 'Podbródnikowate', 'podbrodnikowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(537, 'Molosowate', 'molosowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(538, 'Liścionosowate', 'liscionosowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(539, 'Mroczkowate', 'mroczkowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(540, 'Lejkouchowate', 'lejkouchowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(541, 'Dymnicowate', 'dymnicowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(542, 'Przygowcowate', 'przygowcowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(543, 'Złotawkowate', 'zlotawkowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(544, 'Wąsalowate', 'wasalowate', 96);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(545, 'Tenrekowate', 'tenrekowate', 97);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(546, 'Złotokretowate', 'zlotokretowate', 97);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(547, 'Jeżowate', 'jezowate', 97);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(548, 'Ryjówkowate', 'ryjowkowate', 97);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(549, 'Almikowate', 'almikowate', 97);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(550, 'Kretowate', 'kretowate', 97);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(551, 'Świniowate', 'swiniowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(552, 'Pekariowate', 'pekariowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(553, 'Hipopotamowate', 'hipopotamowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(554, 'Wielbłądowate', 'wielbladowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(555, 'Kanczylkowate', 'kanczylkowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(556, 'Piżmowcowate', 'pizmowcowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(557, 'Jeleniowate', 'jeleniowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(558, 'Żurafowate', 'zurafowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(559, 'Widłorogowate', 'widlorogowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(560, 'Wołowate', 'wolowate', 98);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(561, 'Ryjkonosowate', 'ryjkonosowate', 99);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(562, 'Zbójnikowate', 'zbojnikowate', 100);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(563, 'Kolczatkowate', 'kolczatkowate', 101);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(564, 'Dziobakowate', 'dziobakowate', 101);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(565, 'Diugoniowate', 'diugoniowate', 102);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(566, 'Manatowate', 'manatowate', 102);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(567, 'Mrówkojadowate', 'mrowkojadowate', 103);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(568, 'Leniwcowate', 'leniwcowate', 103);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(569, 'Unauowate', 'unauowate', 103);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(570, 'Pancernikowate', 'pancernikowate', 103);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(571, 'Słoniowate', 'sloniowate', 104);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(572, 'Delfiny', 'delfiny', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(573, 'Morświnowate', 'morswinowate', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(574, 'Delfinowate', 'delfinowate', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(575, 'Kaszalowate', 'kaszalowate', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(576, 'Narwalowate', 'narwalowate', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(577, 'Wale dziobogłowe', 'wale_dzioboglowe', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(578, 'Pływaczowate', 'plywaczowate', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(579, 'Wieloryby fałdowe', 'wieloryby_faldowe', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(580, 'Wieloryby gładkoskóre', 'wieloryby_gladkoskore', 105);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(581, 'Wiewiórecznikowate', 'wiewiorecznikowate', 106);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(582, 'Szczekuszkowate', 'szczekuszkowate', 107);
INSERT INTO `rodzina` (`rodzina_id`, `rodzina`, `slug`, `rzad_id`) VALUES(583, 'Zającowate', 'zajacowate', 107);

--
-- Zrzut danych tabeli `rzad`
--

INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(1, 'Hatteriokształtnee', 'hatterioksztaltnee', 1);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(2, 'Krokodyle', 'krokodyle', 1);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(3, 'Łuskoskóre', 'luskoskore', 1);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(4, 'Żółwie', 'zolwie', 1);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(5, 'Minogokształtne', 'minogoksztaltne', 2);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(6, 'Płazy beznogie', 'plazy_beznogie', 3);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(7, 'Płazy bezogonowe', 'plazy_bezogonowe', 3);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(8, 'Płazy ogoniaste', 'plazy_ogoniaste', 3);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(9, 'Blaszkodziobe', 'blaszkodziobe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(10, 'Brodzące', 'brodzace', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(11, 'Czepigi', 'czepigi', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(12, 'Czubaczowe', 'czubaczowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(13, 'Dudki', 'dudki', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(14, 'Dzięciołowe', 'dzieciolowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(15, 'Dzioborożce', 'dzioborozce', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(16, 'Gołębie', 'golebie', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(17, 'Grzebiące', 'grzebiace', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(18, 'Jerzykowe', 'jerzykowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(19, 'Kolibry', 'kolibry', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(20, 'Kraskowe', 'kraskowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(21, 'Kukułkowe', 'kukulkowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(22, 'Kusaki', 'kusaki', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(23, 'Papugi', 'papugi', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(24, 'Przepiórniki', 'przepiorniki', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(25, 'Sowy', 'sowy', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(26, 'Strusiowe', 'strusiowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(27, 'Trogony', 'trogony', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(28, 'Turaki', 'turaki', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(29, 'Wróblowe', 'wroblowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(30, 'Złotki', 'zlotki', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(31, 'Żurawiowe', 'zurawiowe', 4);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(32, 'Chimerokształtne', 'chimeroksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(33, 'Drętwokształtne', 'dretwoksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(34, 'Koleniokształtne', 'kolenioksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(35, 'Łobegongokształtne', 'lobegongoksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(36, 'Piłonosokształtne', 'pilonosoksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(37, 'Rajokształtne', 'rajoksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(38, 'Raszplokształtne', 'raszploksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(39, 'Rekinokształtne', 'rekinoksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(40, 'Rogatkoształtne', 'rogatkosztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(41, 'Żarłaczokształtne', 'zarlaczoksztaltne', 5);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(42, 'Albuliformes', 'albuliformes', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(43, 'Amiokształtne', 'amioksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(44, 'Arowanokształtne', 'arowanoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(45, 'Aterynokształtne', 'aterynoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(46, 'Aulopiformes', 'aulopiformes', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(47, 'Batrachokształtne', 'batrachoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(48, 'Belonokształtne', 'belonoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(49, 'Beryksokształtne', 'beryksoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(50, 'Ciernikokształtne', 'ciernikoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(51, 'Dorszokształtne', 'dorszoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(52, 'Gardzielcokształtne', 'gardzielcoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(53, 'Jesiotrokształtne', 'jesiotroksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(54, 'Karpieńcokształtne', 'karpiencoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(55, 'Karpiokształtne', 'karpioksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(56, 'Kąsaczokształtne', 'kasaczoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(57, 'Łososioksztaltne', 'lososioksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(58, 'Najeżkokształtne', 'najezkoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(59, 'Niszczukokształtne', 'niszczukoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(60, 'Żuchwikowate', 'zuchwikowate', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(61, 'Okoniopstągokształtne', 'okoniopstagoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(62, 'Piaskolcokształtne', 'piaskolcoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(63, 'Piotroszokształtne', 'piotroszoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(64, 'Płastugokształtne', 'plastugoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(65, 'Skorpenokształtne', 'skorpenoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(66, 'Śledziokształtne', 'sledzioksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(67, 'Stephanoberyciformes', 'stephanoberyciformes', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(68, 'Strojnikokształtne', 'strojnikoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(69, 'Strwolotkoształtne', 'strwolotkosztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(70, 'Strętwokształtne', 'stretwoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(71, 'Stynkokształtne', 'stynkoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(72, 'Sumokształtne', 'sumoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(73, 'Świetlikokształtne', 'swietlikoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(74, 'Szczupakokształtne', 'szczupakoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(75, 'Tarponokształtne', 'tarponoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(76, 'Węgorze szparoskrzelne', 'wegorze_szparoskrzelne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(77, 'Węgorzokształtne', 'wegorzoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(78, 'Wężokształtne', 'wezoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(79, 'Wielopłetwcokształtne', 'wielopletwcoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(80, 'Wyślizgokształtne', 'wyslizgoksztaltne', 6);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(81, 'Śluzicokształtne', 'sluzicoksztaltne', 7);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(82, 'Beztorbiki', 'beztorbiki', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(83, 'Drapieżne', 'drapiezne', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(84, 'Dwuprzodozębowce', 'dwuprzodozebowce', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(85, 'Dydelfy', 'dydelfy', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(86, 'Góralki', 'goralki', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(87, 'Gryzonie', 'gryzonie', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(88, 'Jamraje', 'jamraje', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(89, 'Krety workowate', 'krety_workowate', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(90, 'Latawce', 'latawce', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(91, 'Łuskowce', 'luskowce', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(92, 'Mrówniki', 'mrowniki', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(93, 'Naczelne', 'naczelne', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(94, 'Niełazy', 'nielazy', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(95, 'Nieparzystokopytne', 'nieparzystokopytne', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(96, 'Nietoperze', 'nietoperze', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(97, 'Owadożerne', 'owadozerne', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(98, 'Parzystokopytne', 'parzystokopytne', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(99, 'Ryjkonosy', 'ryjkonosy', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(100, 'Skąpoguzkowce', 'skapoguzkowce', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(101, 'Stekowce', 'stekowce', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(102, 'Syreny', 'syreny', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(103, 'Szczerbaki', 'szczerbaki', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(104, 'Trąbowce', 'trabowce', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(105, 'Walenie', 'walenie', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(106, 'Wiewióreczniki', 'wiewioreczniki', 8);
INSERT INTO `rzad` (`rzad_id`, `rzad`, `slug`, `gromada_id`) VALUES(107, 'Zajęczaki', 'zajeczaki', 8);

SET FOREIGN_KEY_CHECKS=1;
