<?php

require_once 'Smarty.class.php';

$stringTemplates = array();

function smarty_str_get_template($tpl_name, &$tpl_source, &$smarty_obj)
{
    global $stringTemplates;
    
    if (isset($stringTemplates[$tpl_name])) {
        $tpl_source = $stringTemplates[$tpl_name];
        return true;
    } else {
        return false;
    }
}

function smarty_str_get_timestamp($tpl_name, &$tpl_timestamp, &$smarty_obj)
{
    $tpl_timestamp = time() + 1000;
    return true;
}

function smarty_str_get_secure()
{
    return true;
}

function smarty_str_get_trusted()
{
}

class SmartyString extends Smarty
{
    public function __construct()
    {
        parent::__construct();
        $this->register_resource('str',
            array(
                'smarty_str_get_template',
                'smarty_str_get_timestamp',
                'smarty_str_get_secure',
                'smarty_str_get_trusted'
            )
        );
        
        $this->compile_dir  = 'tmp';        
    }

    public function addTemplate($AName, $ATemplate)
    {
        global $stringTemplates;
        
        $stringTemplates[$AName] = $ATemplate;
    }
}

?>
